/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CardBrand;
import com.squareup.square.types.DisputeReason;
import com.squareup.square.types.DisputeState;
import com.squareup.square.types.DisputedPayment;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Dispute {
    private final Optional<String> disputeId;
    private final Optional<String> id;
    private final Optional<Money> amountMoney;
    private final Optional<DisputeReason> reason;
    private final Optional<DisputeState> state;
    private final Optional<String> dueAt;
    private final Optional<DisputedPayment> disputedPayment;
    private final Optional<List<String>> evidenceIds;
    private final Optional<CardBrand> cardBrand;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> brandDisputeId;
    private final Optional<String> reportedDate;
    private final Optional<String> reportedAt;
    private final Optional<Integer> version;
    private final Optional<String> locationId;
    private final Map<String, Object> additionalProperties;

    private Dispute(Optional<String> disputeId, Optional<String> id, Optional<Money> amountMoney, Optional<DisputeReason> reason, Optional<DisputeState> state, Optional<String> dueAt, Optional<DisputedPayment> disputedPayment, Optional<List<String>> evidenceIds, Optional<CardBrand> cardBrand, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> brandDisputeId, Optional<String> reportedDate, Optional<String> reportedAt, Optional<Integer> version, Optional<String> locationId, Map<String, Object> additionalProperties) {
        this.disputeId = disputeId;
        this.id = id;
        this.amountMoney = amountMoney;
        this.reason = reason;
        this.state = state;
        this.dueAt = dueAt;
        this.disputedPayment = disputedPayment;
        this.evidenceIds = evidenceIds;
        this.cardBrand = cardBrand;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.brandDisputeId = brandDisputeId;
        this.reportedDate = reportedDate;
        this.reportedAt = reportedAt;
        this.version = version;
        this.locationId = locationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getDisputeId() {
        if (this.disputeId == null) {
            return Optional.empty();
        }
        return this.disputeId;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="reason")
    public Optional<DisputeReason> getReason() {
        return this.reason;
    }

    @JsonProperty(value="state")
    public Optional<DisputeState> getState() {
        return this.state;
    }

    @JsonIgnore
    public Optional<String> getDueAt() {
        if (this.dueAt == null) {
            return Optional.empty();
        }
        return this.dueAt;
    }

    @JsonProperty(value="disputed_payment")
    public Optional<DisputedPayment> getDisputedPayment() {
        return this.disputedPayment;
    }

    @JsonIgnore
    public Optional<List<String>> getEvidenceIds() {
        if (this.evidenceIds == null) {
            return Optional.empty();
        }
        return this.evidenceIds;
    }

    @JsonProperty(value="card_brand")
    public Optional<CardBrand> getCardBrand() {
        return this.cardBrand;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<String> getBrandDisputeId() {
        if (this.brandDisputeId == null) {
            return Optional.empty();
        }
        return this.brandDisputeId;
    }

    @JsonIgnore
    public Optional<String> getReportedDate() {
        if (this.reportedDate == null) {
            return Optional.empty();
        }
        return this.reportedDate;
    }

    @JsonIgnore
    public Optional<String> getReportedAt() {
        if (this.reportedAt == null) {
            return Optional.empty();
        }
        return this.reportedAt;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="dispute_id")
    private Optional<String> _getDisputeId() {
        return this.disputeId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="due_at")
    private Optional<String> _getDueAt() {
        return this.dueAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="evidence_ids")
    private Optional<List<String>> _getEvidenceIds() {
        return this.evidenceIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="brand_dispute_id")
    private Optional<String> _getBrandDisputeId() {
        return this.brandDisputeId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reported_date")
    private Optional<String> _getReportedDate() {
        return this.reportedDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reported_at")
    private Optional<String> _getReportedAt() {
        return this.reportedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Dispute && this.equalTo((Dispute)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Dispute other) {
        return this.disputeId.equals(other.disputeId) && this.id.equals(other.id) && this.amountMoney.equals(other.amountMoney) && this.reason.equals(other.reason) && this.state.equals(other.state) && this.dueAt.equals(other.dueAt) && this.disputedPayment.equals(other.disputedPayment) && this.evidenceIds.equals(other.evidenceIds) && this.cardBrand.equals(other.cardBrand) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.brandDisputeId.equals(other.brandDisputeId) && this.reportedDate.equals(other.reportedDate) && this.reportedAt.equals(other.reportedAt) && this.version.equals(other.version) && this.locationId.equals(other.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.disputeId, this.id, this.amountMoney, this.reason, this.state, this.dueAt, this.disputedPayment, this.evidenceIds, this.cardBrand, this.createdAt, this.updatedAt, this.brandDisputeId, this.reportedDate, this.reportedAt, this.version, this.locationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> disputeId = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<Money> amountMoney = Optional.empty();
        private Optional<DisputeReason> reason = Optional.empty();
        private Optional<DisputeState> state = Optional.empty();
        private Optional<String> dueAt = Optional.empty();
        private Optional<DisputedPayment> disputedPayment = Optional.empty();
        private Optional<List<String>> evidenceIds = Optional.empty();
        private Optional<CardBrand> cardBrand = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> brandDisputeId = Optional.empty();
        private Optional<String> reportedDate = Optional.empty();
        private Optional<String> reportedAt = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Dispute other) {
            this.disputeId(other.getDisputeId());
            this.id(other.getId());
            this.amountMoney(other.getAmountMoney());
            this.reason(other.getReason());
            this.state(other.getState());
            this.dueAt(other.getDueAt());
            this.disputedPayment(other.getDisputedPayment());
            this.evidenceIds(other.getEvidenceIds());
            this.cardBrand(other.getCardBrand());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.brandDisputeId(other.getBrandDisputeId());
            this.reportedDate(other.getReportedDate());
            this.reportedAt(other.getReportedAt());
            this.version(other.getVersion());
            this.locationId(other.getLocationId());
            return this;
        }

        @JsonSetter(value="dispute_id", nulls=Nulls.SKIP)
        public Builder disputeId(Optional<String> disputeId) {
            this.disputeId = disputeId;
            return this;
        }

        public Builder disputeId(String disputeId) {
            this.disputeId = Optional.ofNullable(disputeId);
            return this;
        }

        public Builder disputeId(Nullable<String> disputeId) {
            this.disputeId = disputeId.isNull() ? null : (disputeId.isEmpty() ? Optional.empty() : Optional.of(disputeId.get()));
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public Builder amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        @JsonSetter(value="reason", nulls=Nulls.SKIP)
        public Builder reason(Optional<DisputeReason> reason) {
            this.reason = reason;
            return this;
        }

        public Builder reason(DisputeReason reason) {
            this.reason = Optional.ofNullable(reason);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<DisputeState> state) {
            this.state = state;
            return this;
        }

        public Builder state(DisputeState state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="due_at", nulls=Nulls.SKIP)
        public Builder dueAt(Optional<String> dueAt) {
            this.dueAt = dueAt;
            return this;
        }

        public Builder dueAt(String dueAt) {
            this.dueAt = Optional.ofNullable(dueAt);
            return this;
        }

        public Builder dueAt(Nullable<String> dueAt) {
            this.dueAt = dueAt.isNull() ? null : (dueAt.isEmpty() ? Optional.empty() : Optional.of(dueAt.get()));
            return this;
        }

        @JsonSetter(value="disputed_payment", nulls=Nulls.SKIP)
        public Builder disputedPayment(Optional<DisputedPayment> disputedPayment) {
            this.disputedPayment = disputedPayment;
            return this;
        }

        public Builder disputedPayment(DisputedPayment disputedPayment) {
            this.disputedPayment = Optional.ofNullable(disputedPayment);
            return this;
        }

        @JsonSetter(value="evidence_ids", nulls=Nulls.SKIP)
        public Builder evidenceIds(Optional<List<String>> evidenceIds) {
            this.evidenceIds = evidenceIds;
            return this;
        }

        public Builder evidenceIds(List<String> evidenceIds) {
            this.evidenceIds = Optional.ofNullable(evidenceIds);
            return this;
        }

        public Builder evidenceIds(Nullable<List<String>> evidenceIds) {
            this.evidenceIds = evidenceIds.isNull() ? null : (evidenceIds.isEmpty() ? Optional.empty() : Optional.of(evidenceIds.get()));
            return this;
        }

        @JsonSetter(value="card_brand", nulls=Nulls.SKIP)
        public Builder cardBrand(Optional<CardBrand> cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        public Builder cardBrand(CardBrand cardBrand) {
            this.cardBrand = Optional.ofNullable(cardBrand);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="brand_dispute_id", nulls=Nulls.SKIP)
        public Builder brandDisputeId(Optional<String> brandDisputeId) {
            this.brandDisputeId = brandDisputeId;
            return this;
        }

        public Builder brandDisputeId(String brandDisputeId) {
            this.brandDisputeId = Optional.ofNullable(brandDisputeId);
            return this;
        }

        public Builder brandDisputeId(Nullable<String> brandDisputeId) {
            this.brandDisputeId = brandDisputeId.isNull() ? null : (brandDisputeId.isEmpty() ? Optional.empty() : Optional.of(brandDisputeId.get()));
            return this;
        }

        @JsonSetter(value="reported_date", nulls=Nulls.SKIP)
        public Builder reportedDate(Optional<String> reportedDate) {
            this.reportedDate = reportedDate;
            return this;
        }

        public Builder reportedDate(String reportedDate) {
            this.reportedDate = Optional.ofNullable(reportedDate);
            return this;
        }

        public Builder reportedDate(Nullable<String> reportedDate) {
            this.reportedDate = reportedDate.isNull() ? null : (reportedDate.isEmpty() ? Optional.empty() : Optional.of(reportedDate.get()));
            return this;
        }

        @JsonSetter(value="reported_at", nulls=Nulls.SKIP)
        public Builder reportedAt(Optional<String> reportedAt) {
            this.reportedAt = reportedAt;
            return this;
        }

        public Builder reportedAt(String reportedAt) {
            this.reportedAt = Optional.ofNullable(reportedAt);
            return this;
        }

        public Builder reportedAt(Nullable<String> reportedAt) {
            this.reportedAt = reportedAt.isNull() ? null : (reportedAt.isEmpty() ? Optional.empty() : Optional.of(reportedAt.get()));
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        public Dispute build() {
            return new Dispute(this.disputeId, this.id, this.amountMoney, this.reason, this.state, this.dueAt, this.disputedPayment, this.evidenceIds, this.cardBrand, this.createdAt, this.updatedAt, this.brandDisputeId, this.reportedDate, this.reportedAt, this.version, this.locationId, this.additionalProperties);
        }
    }
}

