/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DisputeEvidenceFile {
    private final Optional<String> filename;
    private final Optional<String> filetype;
    private final Map<String, Object> additionalProperties;

    private DisputeEvidenceFile(Optional<String> filename, Optional<String> filetype, Map<String, Object> additionalProperties) {
        this.filename = filename;
        this.filetype = filetype;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getFilename() {
        if (this.filename == null) {
            return Optional.empty();
        }
        return this.filename;
    }

    @JsonIgnore
    public Optional<String> getFiletype() {
        if (this.filetype == null) {
            return Optional.empty();
        }
        return this.filetype;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filename")
    private Optional<String> _getFilename() {
        return this.filename;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="filetype")
    private Optional<String> _getFiletype() {
        return this.filetype;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DisputeEvidenceFile && this.equalTo((DisputeEvidenceFile)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DisputeEvidenceFile other) {
        return this.filename.equals(other.filename) && this.filetype.equals(other.filetype);
    }

    public int hashCode() {
        return Objects.hash(this.filename, this.filetype);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> filename = Optional.empty();
        private Optional<String> filetype = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DisputeEvidenceFile other) {
            this.filename(other.getFilename());
            this.filetype(other.getFiletype());
            return this;
        }

        @JsonSetter(value="filename", nulls=Nulls.SKIP)
        public Builder filename(Optional<String> filename) {
            this.filename = filename;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = Optional.ofNullable(filename);
            return this;
        }

        public Builder filename(Nullable<String> filename) {
            this.filename = filename.isNull() ? null : (filename.isEmpty() ? Optional.empty() : Optional.of(filename.get()));
            return this;
        }

        @JsonSetter(value="filetype", nulls=Nulls.SKIP)
        public Builder filetype(Optional<String> filetype) {
            this.filetype = filetype;
            return this;
        }

        public Builder filetype(String filetype) {
            this.filetype = Optional.ofNullable(filetype);
            return this;
        }

        public Builder filetype(Nullable<String> filetype) {
            this.filetype = filetype.isNull() ? null : (filetype.isEmpty() ? Optional.empty() : Optional.of(filetype.get()));
            return this;
        }

        public DisputeEvidenceFile build() {
            return new DisputeEvidenceFile(this.filename, this.filetype, this.additionalProperties);
        }
    }
}

