/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class EcomVisibility {
    public static final EcomVisibility UNAVAILABLE = new EcomVisibility(Value.UNAVAILABLE, "UNAVAILABLE");
    public static final EcomVisibility UNINDEXED = new EcomVisibility(Value.UNINDEXED, "UNINDEXED");
    public static final EcomVisibility HIDDEN = new EcomVisibility(Value.HIDDEN, "HIDDEN");
    public static final EcomVisibility VISIBLE = new EcomVisibility(Value.VISIBLE, "VISIBLE");
    private final Value value;
    private final String string;

    EcomVisibility(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof EcomVisibility && this.string.equals(((EcomVisibility)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case UNAVAILABLE: {
                return visitor.visitUnavailable();
            }
            case UNINDEXED: {
                return visitor.visitUnindexed();
            }
            case HIDDEN: {
                return visitor.visitHidden();
            }
            case VISIBLE: {
                return visitor.visitVisible();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static EcomVisibility valueOf(String value) {
        switch (value) {
            case "UNAVAILABLE": {
                return UNAVAILABLE;
            }
            case "UNINDEXED": {
                return UNINDEXED;
            }
            case "HIDDEN": {
                return HIDDEN;
            }
            case "VISIBLE": {
                return VISIBLE;
            }
        }
        return new EcomVisibility(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitUnindexed();

        public T visitUnavailable();

        public T visitHidden();

        public T visitVisible();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        UNINDEXED,
        UNAVAILABLE,
        HIDDEN,
        VISIBLE,
        UNKNOWN;

    }
}

