/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EmployeeWage {
    private final Optional<String> id;
    private final Optional<String> employeeId;
    private final Optional<String> title;
    private final Optional<Money> hourlyRate;
    private final Map<String, Object> additionalProperties;

    private EmployeeWage(Optional<String> id, Optional<String> employeeId, Optional<String> title, Optional<Money> hourlyRate, Map<String, Object> additionalProperties) {
        this.id = id;
        this.employeeId = employeeId;
        this.title = title;
        this.hourlyRate = hourlyRate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getEmployeeId() {
        if (this.employeeId == null) {
            return Optional.empty();
        }
        return this.employeeId;
    }

    @JsonIgnore
    public Optional<String> getTitle() {
        if (this.title == null) {
            return Optional.empty();
        }
        return this.title;
    }

    @JsonProperty(value="hourly_rate")
    public Optional<Money> getHourlyRate() {
        return this.hourlyRate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="employee_id")
    private Optional<String> _getEmployeeId() {
        return this.employeeId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="title")
    private Optional<String> _getTitle() {
        return this.title;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EmployeeWage && this.equalTo((EmployeeWage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EmployeeWage other) {
        return this.id.equals(other.id) && this.employeeId.equals(other.employeeId) && this.title.equals(other.title) && this.hourlyRate.equals(other.hourlyRate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.employeeId, this.title, this.hourlyRate);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> employeeId = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<Money> hourlyRate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EmployeeWage other) {
            this.id(other.getId());
            this.employeeId(other.getEmployeeId());
            this.title(other.getTitle());
            this.hourlyRate(other.getHourlyRate());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="employee_id", nulls=Nulls.SKIP)
        public Builder employeeId(Optional<String> employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = Optional.ofNullable(employeeId);
            return this;
        }

        public Builder employeeId(Nullable<String> employeeId) {
            this.employeeId = employeeId.isNull() ? null : (employeeId.isEmpty() ? Optional.empty() : Optional.of(employeeId.get()));
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        public Builder title(Nullable<String> title) {
            this.title = title.isNull() ? null : (title.isEmpty() ? Optional.empty() : Optional.of(title.get()));
            return this;
        }

        @JsonSetter(value="hourly_rate", nulls=Nulls.SKIP)
        public Builder hourlyRate(Optional<Money> hourlyRate) {
            this.hourlyRate = hourlyRate;
            return this;
        }

        public Builder hourlyRate(Money hourlyRate) {
            this.hourlyRate = Optional.ofNullable(hourlyRate);
            return this;
        }

        public EmployeeWage build() {
            return new EmployeeWage(this.id, this.employeeId, this.title, this.hourlyRate, this.additionalProperties);
        }
    }
}

