/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EventData {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<Boolean> deleted;
    private final Optional<Map<String, Object>> object;
    private final Map<String, Object> additionalProperties;

    private EventData(Optional<String> type, Optional<String> id, Optional<Boolean> deleted, Optional<Map<String, Object>> object, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.deleted = deleted;
        this.object = object;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getType() {
        if (this.type == null) {
            return Optional.empty();
        }
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<Boolean> getDeleted() {
        if (this.deleted == null) {
            return Optional.empty();
        }
        return this.deleted;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> getObject() {
        if (this.object == null) {
            return Optional.empty();
        }
        return this.object;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="type")
    private Optional<String> _getType() {
        return this.type;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="deleted")
    private Optional<Boolean> _getDeleted() {
        return this.deleted;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="object")
    private Optional<Map<String, Object>> _getObject() {
        return this.object;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventData && this.equalTo((EventData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventData other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.deleted.equals(other.deleted) && this.object.equals(other.object);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.deleted, this.object);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<Boolean> deleted = Optional.empty();
        private Optional<Map<String, Object>> object = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EventData other) {
            this.type(other.getType());
            this.id(other.getId());
            this.deleted(other.getDeleted());
            this.object(other.getObject());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        public Builder type(Nullable<String> type) {
            this.type = type.isNull() ? null : (type.isEmpty() ? Optional.empty() : Optional.of(type.get()));
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="deleted", nulls=Nulls.SKIP)
        public Builder deleted(Optional<Boolean> deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder deleted(Boolean deleted) {
            this.deleted = Optional.ofNullable(deleted);
            return this;
        }

        public Builder deleted(Nullable<Boolean> deleted) {
            this.deleted = deleted.isNull() ? null : (deleted.isEmpty() ? Optional.empty() : Optional.of(deleted.get()));
            return this;
        }

        @JsonSetter(value="object", nulls=Nulls.SKIP)
        public Builder object(Optional<Map<String, Object>> object) {
            this.object = object;
            return this;
        }

        public Builder object(Map<String, Object> object) {
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Nullable<Map<String, Object>> object) {
            this.object = object.isNull() ? null : (object.isEmpty() ? Optional.empty() : Optional.of(object.get()));
            return this;
        }

        public EventData build() {
            return new EventData(this.type, this.id, this.deleted, this.object, this.additionalProperties);
        }
    }
}

