/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FilterValue {
    private final Optional<List<String>> all;
    private final Optional<List<String>> any;
    private final Optional<List<String>> none;
    private final Map<String, Object> additionalProperties;

    private FilterValue(Optional<List<String>> all, Optional<List<String>> any, Optional<List<String>> none, Map<String, Object> additionalProperties) {
        this.all = all;
        this.any = any;
        this.none = none;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<String>> getAll() {
        if (this.all == null) {
            return Optional.empty();
        }
        return this.all;
    }

    @JsonIgnore
    public Optional<List<String>> getAny() {
        if (this.any == null) {
            return Optional.empty();
        }
        return this.any;
    }

    @JsonIgnore
    public Optional<List<String>> getNone() {
        if (this.none == null) {
            return Optional.empty();
        }
        return this.none;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="all")
    private Optional<List<String>> _getAll() {
        return this.all;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="any")
    private Optional<List<String>> _getAny() {
        return this.any;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="none")
    private Optional<List<String>> _getNone() {
        return this.none;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FilterValue && this.equalTo((FilterValue)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FilterValue other) {
        return this.all.equals(other.all) && this.any.equals(other.any) && this.none.equals(other.none);
    }

    public int hashCode() {
        return Objects.hash(this.all, this.any, this.none);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> all = Optional.empty();
        private Optional<List<String>> any = Optional.empty();
        private Optional<List<String>> none = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(FilterValue other) {
            this.all(other.getAll());
            this.any(other.getAny());
            this.none(other.getNone());
            return this;
        }

        @JsonSetter(value="all", nulls=Nulls.SKIP)
        public Builder all(Optional<List<String>> all) {
            this.all = all;
            return this;
        }

        public Builder all(List<String> all) {
            this.all = Optional.ofNullable(all);
            return this;
        }

        public Builder all(Nullable<List<String>> all) {
            this.all = all.isNull() ? null : (all.isEmpty() ? Optional.empty() : Optional.of(all.get()));
            return this;
        }

        @JsonSetter(value="any", nulls=Nulls.SKIP)
        public Builder any(Optional<List<String>> any) {
            this.any = any;
            return this;
        }

        public Builder any(List<String> any) {
            this.any = Optional.ofNullable(any);
            return this;
        }

        public Builder any(Nullable<List<String>> any) {
            this.any = any.isNull() ? null : (any.isEmpty() ? Optional.empty() : Optional.of(any.get()));
            return this;
        }

        @JsonSetter(value="none", nulls=Nulls.SKIP)
        public Builder none(Optional<List<String>> none) {
            this.none = none;
            return this;
        }

        public Builder none(List<String> none) {
            this.none = Optional.ofNullable(none);
            return this;
        }

        public Builder none(Nullable<List<String>> none) {
            this.none = none.isNull() ? null : (none.isEmpty() ? Optional.empty() : Optional.of(none.get()));
            return this;
        }

        public FilterValue build() {
            return new FilterValue(this.all, this.any, this.none, this.additionalProperties);
        }
    }
}

