/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FulfillmentFulfillmentEntry {
    private final Optional<String> uid;
    private final String lineItemUid;
    private final String quantity;
    private final Optional<Map<String, Optional<String>>> metadata;
    private final Map<String, Object> additionalProperties;

    private FulfillmentFulfillmentEntry(Optional<String> uid, String lineItemUid, String quantity, Optional<Map<String, Optional<String>>> metadata, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.lineItemUid = lineItemUid;
        this.quantity = quantity;
        this.metadata = metadata;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonProperty(value="line_item_uid")
    public String getLineItemUid() {
        return this.lineItemUid;
    }

    @JsonProperty(value="quantity")
    public String getQuantity() {
        return this.quantity;
    }

    @JsonIgnore
    public Optional<Map<String, Optional<String>>> getMetadata() {
        if (this.metadata == null) {
            return Optional.empty();
        }
        return this.metadata;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="metadata")
    private Optional<Map<String, Optional<String>>> _getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FulfillmentFulfillmentEntry && this.equalTo((FulfillmentFulfillmentEntry)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FulfillmentFulfillmentEntry other) {
        return this.uid.equals(other.uid) && this.lineItemUid.equals(other.lineItemUid) && this.quantity.equals(other.quantity) && this.metadata.equals(other.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.lineItemUid, this.quantity, this.metadata);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LineItemUidStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LineItemUidStage,
    QuantityStage,
    _FinalStage {
        private String lineItemUid;
        private String quantity;
        private Optional<Map<String, Optional<String>>> metadata = Optional.empty();
        private Optional<String> uid = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FulfillmentFulfillmentEntry other) {
            this.uid(other.getUid());
            this.lineItemUid(other.getLineItemUid());
            this.quantity(other.getQuantity());
            this.metadata(other.getMetadata());
            return this;
        }

        @Override
        @JsonSetter(value="line_item_uid")
        public QuantityStage lineItemUid(@NotNull String lineItemUid) {
            this.lineItemUid = Objects.requireNonNull(lineItemUid, "lineItemUid must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public _FinalStage quantity(@NotNull String quantity) {
            this.quantity = Objects.requireNonNull(quantity, "quantity must not be null");
            return this;
        }

        @Override
        public _FinalStage metadata(Nullable<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata.isNull() ? null : (metadata.isEmpty() ? Optional.empty() : Optional.of(metadata.get()));
            return this;
        }

        @Override
        public _FinalStage metadata(Map<String, Optional<String>> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @Override
        public _FinalStage uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        @Override
        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public _FinalStage uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        @Override
        public FulfillmentFulfillmentEntry build() {
            return new FulfillmentFulfillmentEntry(this.uid, this.lineItemUid, this.quantity, this.metadata, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FulfillmentFulfillmentEntry build();

        public _FinalStage uid(Optional<String> var1);

        public _FinalStage uid(String var1);

        public _FinalStage uid(Nullable<String> var1);

        public _FinalStage metadata(Optional<Map<String, Optional<String>>> var1);

        public _FinalStage metadata(Map<String, Optional<String>> var1);

        public _FinalStage metadata(Nullable<Map<String, Optional<String>>> var1);
    }

    public static interface QuantityStage {
        public _FinalStage quantity(@NotNull String var1);
    }

    public static interface LineItemUidStage {
        public QuantityStage lineItemUid(@NotNull String var1);

        public Builder from(FulfillmentFulfillmentEntry var1);
    }
}

