/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.FulfillmentPickupDetailsCurbsidePickupDetails;
import com.squareup.square.types.FulfillmentPickupDetailsScheduleType;
import com.squareup.square.types.FulfillmentRecipient;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FulfillmentPickupDetails {
    private final Optional<FulfillmentRecipient> recipient;
    private final Optional<String> expiresAt;
    private final Optional<String> autoCompleteDuration;
    private final Optional<FulfillmentPickupDetailsScheduleType> scheduleType;
    private final Optional<String> pickupAt;
    private final Optional<String> pickupWindowDuration;
    private final Optional<String> prepTimeDuration;
    private final Optional<String> note;
    private final Optional<String> placedAt;
    private final Optional<String> acceptedAt;
    private final Optional<String> rejectedAt;
    private final Optional<String> readyAt;
    private final Optional<String> expiredAt;
    private final Optional<String> pickedUpAt;
    private final Optional<String> canceledAt;
    private final Optional<String> cancelReason;
    private final Optional<Boolean> isCurbsidePickup;
    private final Optional<FulfillmentPickupDetailsCurbsidePickupDetails> curbsidePickupDetails;
    private final Map<String, Object> additionalProperties;

    private FulfillmentPickupDetails(Optional<FulfillmentRecipient> recipient, Optional<String> expiresAt, Optional<String> autoCompleteDuration, Optional<FulfillmentPickupDetailsScheduleType> scheduleType, Optional<String> pickupAt, Optional<String> pickupWindowDuration, Optional<String> prepTimeDuration, Optional<String> note, Optional<String> placedAt, Optional<String> acceptedAt, Optional<String> rejectedAt, Optional<String> readyAt, Optional<String> expiredAt, Optional<String> pickedUpAt, Optional<String> canceledAt, Optional<String> cancelReason, Optional<Boolean> isCurbsidePickup, Optional<FulfillmentPickupDetailsCurbsidePickupDetails> curbsidePickupDetails, Map<String, Object> additionalProperties) {
        this.recipient = recipient;
        this.expiresAt = expiresAt;
        this.autoCompleteDuration = autoCompleteDuration;
        this.scheduleType = scheduleType;
        this.pickupAt = pickupAt;
        this.pickupWindowDuration = pickupWindowDuration;
        this.prepTimeDuration = prepTimeDuration;
        this.note = note;
        this.placedAt = placedAt;
        this.acceptedAt = acceptedAt;
        this.rejectedAt = rejectedAt;
        this.readyAt = readyAt;
        this.expiredAt = expiredAt;
        this.pickedUpAt = pickedUpAt;
        this.canceledAt = canceledAt;
        this.cancelReason = cancelReason;
        this.isCurbsidePickup = isCurbsidePickup;
        this.curbsidePickupDetails = curbsidePickupDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="recipient")
    public Optional<FulfillmentRecipient> getRecipient() {
        return this.recipient;
    }

    @JsonIgnore
    public Optional<String> getExpiresAt() {
        if (this.expiresAt == null) {
            return Optional.empty();
        }
        return this.expiresAt;
    }

    @JsonIgnore
    public Optional<String> getAutoCompleteDuration() {
        if (this.autoCompleteDuration == null) {
            return Optional.empty();
        }
        return this.autoCompleteDuration;
    }

    @JsonProperty(value="schedule_type")
    public Optional<FulfillmentPickupDetailsScheduleType> getScheduleType() {
        return this.scheduleType;
    }

    @JsonIgnore
    public Optional<String> getPickupAt() {
        if (this.pickupAt == null) {
            return Optional.empty();
        }
        return this.pickupAt;
    }

    @JsonIgnore
    public Optional<String> getPickupWindowDuration() {
        if (this.pickupWindowDuration == null) {
            return Optional.empty();
        }
        return this.pickupWindowDuration;
    }

    @JsonIgnore
    public Optional<String> getPrepTimeDuration() {
        if (this.prepTimeDuration == null) {
            return Optional.empty();
        }
        return this.prepTimeDuration;
    }

    @JsonIgnore
    public Optional<String> getNote() {
        if (this.note == null) {
            return Optional.empty();
        }
        return this.note;
    }

    @JsonProperty(value="placed_at")
    public Optional<String> getPlacedAt() {
        return this.placedAt;
    }

    @JsonProperty(value="accepted_at")
    public Optional<String> getAcceptedAt() {
        return this.acceptedAt;
    }

    @JsonProperty(value="rejected_at")
    public Optional<String> getRejectedAt() {
        return this.rejectedAt;
    }

    @JsonProperty(value="ready_at")
    public Optional<String> getReadyAt() {
        return this.readyAt;
    }

    @JsonProperty(value="expired_at")
    public Optional<String> getExpiredAt() {
        return this.expiredAt;
    }

    @JsonProperty(value="picked_up_at")
    public Optional<String> getPickedUpAt() {
        return this.pickedUpAt;
    }

    @JsonProperty(value="canceled_at")
    public Optional<String> getCanceledAt() {
        return this.canceledAt;
    }

    @JsonIgnore
    public Optional<String> getCancelReason() {
        if (this.cancelReason == null) {
            return Optional.empty();
        }
        return this.cancelReason;
    }

    @JsonIgnore
    public Optional<Boolean> getIsCurbsidePickup() {
        if (this.isCurbsidePickup == null) {
            return Optional.empty();
        }
        return this.isCurbsidePickup;
    }

    @JsonProperty(value="curbside_pickup_details")
    public Optional<FulfillmentPickupDetailsCurbsidePickupDetails> getCurbsidePickupDetails() {
        return this.curbsidePickupDetails;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="expires_at")
    private Optional<String> _getExpiresAt() {
        return this.expiresAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="auto_complete_duration")
    private Optional<String> _getAutoCompleteDuration() {
        return this.autoCompleteDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="pickup_at")
    private Optional<String> _getPickupAt() {
        return this.pickupAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="pickup_window_duration")
    private Optional<String> _getPickupWindowDuration() {
        return this.pickupWindowDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="prep_time_duration")
    private Optional<String> _getPrepTimeDuration() {
        return this.prepTimeDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="note")
    private Optional<String> _getNote() {
        return this.note;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cancel_reason")
    private Optional<String> _getCancelReason() {
        return this.cancelReason;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_curbside_pickup")
    private Optional<Boolean> _getIsCurbsidePickup() {
        return this.isCurbsidePickup;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FulfillmentPickupDetails && this.equalTo((FulfillmentPickupDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FulfillmentPickupDetails other) {
        return this.recipient.equals(other.recipient) && this.expiresAt.equals(other.expiresAt) && this.autoCompleteDuration.equals(other.autoCompleteDuration) && this.scheduleType.equals(other.scheduleType) && this.pickupAt.equals(other.pickupAt) && this.pickupWindowDuration.equals(other.pickupWindowDuration) && this.prepTimeDuration.equals(other.prepTimeDuration) && this.note.equals(other.note) && this.placedAt.equals(other.placedAt) && this.acceptedAt.equals(other.acceptedAt) && this.rejectedAt.equals(other.rejectedAt) && this.readyAt.equals(other.readyAt) && this.expiredAt.equals(other.expiredAt) && this.pickedUpAt.equals(other.pickedUpAt) && this.canceledAt.equals(other.canceledAt) && this.cancelReason.equals(other.cancelReason) && this.isCurbsidePickup.equals(other.isCurbsidePickup) && this.curbsidePickupDetails.equals(other.curbsidePickupDetails);
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.expiresAt, this.autoCompleteDuration, this.scheduleType, this.pickupAt, this.pickupWindowDuration, this.prepTimeDuration, this.note, this.placedAt, this.acceptedAt, this.rejectedAt, this.readyAt, this.expiredAt, this.pickedUpAt, this.canceledAt, this.cancelReason, this.isCurbsidePickup, this.curbsidePickupDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<FulfillmentRecipient> recipient = Optional.empty();
        private Optional<String> expiresAt = Optional.empty();
        private Optional<String> autoCompleteDuration = Optional.empty();
        private Optional<FulfillmentPickupDetailsScheduleType> scheduleType = Optional.empty();
        private Optional<String> pickupAt = Optional.empty();
        private Optional<String> pickupWindowDuration = Optional.empty();
        private Optional<String> prepTimeDuration = Optional.empty();
        private Optional<String> note = Optional.empty();
        private Optional<String> placedAt = Optional.empty();
        private Optional<String> acceptedAt = Optional.empty();
        private Optional<String> rejectedAt = Optional.empty();
        private Optional<String> readyAt = Optional.empty();
        private Optional<String> expiredAt = Optional.empty();
        private Optional<String> pickedUpAt = Optional.empty();
        private Optional<String> canceledAt = Optional.empty();
        private Optional<String> cancelReason = Optional.empty();
        private Optional<Boolean> isCurbsidePickup = Optional.empty();
        private Optional<FulfillmentPickupDetailsCurbsidePickupDetails> curbsidePickupDetails = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(FulfillmentPickupDetails other) {
            this.recipient(other.getRecipient());
            this.expiresAt(other.getExpiresAt());
            this.autoCompleteDuration(other.getAutoCompleteDuration());
            this.scheduleType(other.getScheduleType());
            this.pickupAt(other.getPickupAt());
            this.pickupWindowDuration(other.getPickupWindowDuration());
            this.prepTimeDuration(other.getPrepTimeDuration());
            this.note(other.getNote());
            this.placedAt(other.getPlacedAt());
            this.acceptedAt(other.getAcceptedAt());
            this.rejectedAt(other.getRejectedAt());
            this.readyAt(other.getReadyAt());
            this.expiredAt(other.getExpiredAt());
            this.pickedUpAt(other.getPickedUpAt());
            this.canceledAt(other.getCanceledAt());
            this.cancelReason(other.getCancelReason());
            this.isCurbsidePickup(other.getIsCurbsidePickup());
            this.curbsidePickupDetails(other.getCurbsidePickupDetails());
            return this;
        }

        @JsonSetter(value="recipient", nulls=Nulls.SKIP)
        public Builder recipient(Optional<FulfillmentRecipient> recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder recipient(FulfillmentRecipient recipient) {
            this.recipient = Optional.ofNullable(recipient);
            return this;
        }

        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public Builder expiresAt(Optional<String> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder expiresAt(String expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        public Builder expiresAt(Nullable<String> expiresAt) {
            this.expiresAt = expiresAt.isNull() ? null : (expiresAt.isEmpty() ? Optional.empty() : Optional.of(expiresAt.get()));
            return this;
        }

        @JsonSetter(value="auto_complete_duration", nulls=Nulls.SKIP)
        public Builder autoCompleteDuration(Optional<String> autoCompleteDuration) {
            this.autoCompleteDuration = autoCompleteDuration;
            return this;
        }

        public Builder autoCompleteDuration(String autoCompleteDuration) {
            this.autoCompleteDuration = Optional.ofNullable(autoCompleteDuration);
            return this;
        }

        public Builder autoCompleteDuration(Nullable<String> autoCompleteDuration) {
            this.autoCompleteDuration = autoCompleteDuration.isNull() ? null : (autoCompleteDuration.isEmpty() ? Optional.empty() : Optional.of(autoCompleteDuration.get()));
            return this;
        }

        @JsonSetter(value="schedule_type", nulls=Nulls.SKIP)
        public Builder scheduleType(Optional<FulfillmentPickupDetailsScheduleType> scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        public Builder scheduleType(FulfillmentPickupDetailsScheduleType scheduleType) {
            this.scheduleType = Optional.ofNullable(scheduleType);
            return this;
        }

        @JsonSetter(value="pickup_at", nulls=Nulls.SKIP)
        public Builder pickupAt(Optional<String> pickupAt) {
            this.pickupAt = pickupAt;
            return this;
        }

        public Builder pickupAt(String pickupAt) {
            this.pickupAt = Optional.ofNullable(pickupAt);
            return this;
        }

        public Builder pickupAt(Nullable<String> pickupAt) {
            this.pickupAt = pickupAt.isNull() ? null : (pickupAt.isEmpty() ? Optional.empty() : Optional.of(pickupAt.get()));
            return this;
        }

        @JsonSetter(value="pickup_window_duration", nulls=Nulls.SKIP)
        public Builder pickupWindowDuration(Optional<String> pickupWindowDuration) {
            this.pickupWindowDuration = pickupWindowDuration;
            return this;
        }

        public Builder pickupWindowDuration(String pickupWindowDuration) {
            this.pickupWindowDuration = Optional.ofNullable(pickupWindowDuration);
            return this;
        }

        public Builder pickupWindowDuration(Nullable<String> pickupWindowDuration) {
            this.pickupWindowDuration = pickupWindowDuration.isNull() ? null : (pickupWindowDuration.isEmpty() ? Optional.empty() : Optional.of(pickupWindowDuration.get()));
            return this;
        }

        @JsonSetter(value="prep_time_duration", nulls=Nulls.SKIP)
        public Builder prepTimeDuration(Optional<String> prepTimeDuration) {
            this.prepTimeDuration = prepTimeDuration;
            return this;
        }

        public Builder prepTimeDuration(String prepTimeDuration) {
            this.prepTimeDuration = Optional.ofNullable(prepTimeDuration);
            return this;
        }

        public Builder prepTimeDuration(Nullable<String> prepTimeDuration) {
            this.prepTimeDuration = prepTimeDuration.isNull() ? null : (prepTimeDuration.isEmpty() ? Optional.empty() : Optional.of(prepTimeDuration.get()));
            return this;
        }

        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public Builder note(Optional<String> note) {
            this.note = note;
            return this;
        }

        public Builder note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        public Builder note(Nullable<String> note) {
            this.note = note.isNull() ? null : (note.isEmpty() ? Optional.empty() : Optional.of(note.get()));
            return this;
        }

        @JsonSetter(value="placed_at", nulls=Nulls.SKIP)
        public Builder placedAt(Optional<String> placedAt) {
            this.placedAt = placedAt;
            return this;
        }

        public Builder placedAt(String placedAt) {
            this.placedAt = Optional.ofNullable(placedAt);
            return this;
        }

        @JsonSetter(value="accepted_at", nulls=Nulls.SKIP)
        public Builder acceptedAt(Optional<String> acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        public Builder acceptedAt(String acceptedAt) {
            this.acceptedAt = Optional.ofNullable(acceptedAt);
            return this;
        }

        @JsonSetter(value="rejected_at", nulls=Nulls.SKIP)
        public Builder rejectedAt(Optional<String> rejectedAt) {
            this.rejectedAt = rejectedAt;
            return this;
        }

        public Builder rejectedAt(String rejectedAt) {
            this.rejectedAt = Optional.ofNullable(rejectedAt);
            return this;
        }

        @JsonSetter(value="ready_at", nulls=Nulls.SKIP)
        public Builder readyAt(Optional<String> readyAt) {
            this.readyAt = readyAt;
            return this;
        }

        public Builder readyAt(String readyAt) {
            this.readyAt = Optional.ofNullable(readyAt);
            return this;
        }

        @JsonSetter(value="expired_at", nulls=Nulls.SKIP)
        public Builder expiredAt(Optional<String> expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        public Builder expiredAt(String expiredAt) {
            this.expiredAt = Optional.ofNullable(expiredAt);
            return this;
        }

        @JsonSetter(value="picked_up_at", nulls=Nulls.SKIP)
        public Builder pickedUpAt(Optional<String> pickedUpAt) {
            this.pickedUpAt = pickedUpAt;
            return this;
        }

        public Builder pickedUpAt(String pickedUpAt) {
            this.pickedUpAt = Optional.ofNullable(pickedUpAt);
            return this;
        }

        @JsonSetter(value="canceled_at", nulls=Nulls.SKIP)
        public Builder canceledAt(Optional<String> canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        public Builder canceledAt(String canceledAt) {
            this.canceledAt = Optional.ofNullable(canceledAt);
            return this;
        }

        @JsonSetter(value="cancel_reason", nulls=Nulls.SKIP)
        public Builder cancelReason(Optional<String> cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public Builder cancelReason(String cancelReason) {
            this.cancelReason = Optional.ofNullable(cancelReason);
            return this;
        }

        public Builder cancelReason(Nullable<String> cancelReason) {
            this.cancelReason = cancelReason.isNull() ? null : (cancelReason.isEmpty() ? Optional.empty() : Optional.of(cancelReason.get()));
            return this;
        }

        @JsonSetter(value="is_curbside_pickup", nulls=Nulls.SKIP)
        public Builder isCurbsidePickup(Optional<Boolean> isCurbsidePickup) {
            this.isCurbsidePickup = isCurbsidePickup;
            return this;
        }

        public Builder isCurbsidePickup(Boolean isCurbsidePickup) {
            this.isCurbsidePickup = Optional.ofNullable(isCurbsidePickup);
            return this;
        }

        public Builder isCurbsidePickup(Nullable<Boolean> isCurbsidePickup) {
            this.isCurbsidePickup = isCurbsidePickup.isNull() ? null : (isCurbsidePickup.isEmpty() ? Optional.empty() : Optional.of(isCurbsidePickup.get()));
            return this;
        }

        @JsonSetter(value="curbside_pickup_details", nulls=Nulls.SKIP)
        public Builder curbsidePickupDetails(Optional<FulfillmentPickupDetailsCurbsidePickupDetails> curbsidePickupDetails) {
            this.curbsidePickupDetails = curbsidePickupDetails;
            return this;
        }

        public Builder curbsidePickupDetails(FulfillmentPickupDetailsCurbsidePickupDetails curbsidePickupDetails) {
            this.curbsidePickupDetails = Optional.ofNullable(curbsidePickupDetails);
            return this;
        }

        public FulfillmentPickupDetails build() {
            return new FulfillmentPickupDetails(this.recipient, this.expiresAt, this.autoCompleteDuration, this.scheduleType, this.pickupAt, this.pickupWindowDuration, this.prepTimeDuration, this.note, this.placedAt, this.acceptedAt, this.rejectedAt, this.readyAt, this.expiredAt, this.pickedUpAt, this.canceledAt, this.cancelReason, this.isCurbsidePickup, this.curbsidePickupDetails, this.additionalProperties);
        }
    }
}

