/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class FulfillmentState {
    public static final FulfillmentState CANCELED = new FulfillmentState(Value.CANCELED, "CANCELED");
    public static final FulfillmentState PROPOSED = new FulfillmentState(Value.PROPOSED, "PROPOSED");
    public static final FulfillmentState COMPLETED = new FulfillmentState(Value.COMPLETED, "COMPLETED");
    public static final FulfillmentState RESERVED = new FulfillmentState(Value.RESERVED, "RESERVED");
    public static final FulfillmentState PREPARED = new FulfillmentState(Value.PREPARED, "PREPARED");
    public static final FulfillmentState FAILED = new FulfillmentState(Value.FAILED, "FAILED");
    private final Value value;
    private final String string;

    FulfillmentState(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof FulfillmentState && this.string.equals(((FulfillmentState)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CANCELED: {
                return visitor.visitCanceled();
            }
            case PROPOSED: {
                return visitor.visitProposed();
            }
            case COMPLETED: {
                return visitor.visitCompleted();
            }
            case RESERVED: {
                return visitor.visitReserved();
            }
            case PREPARED: {
                return visitor.visitPrepared();
            }
            case FAILED: {
                return visitor.visitFailed();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static FulfillmentState valueOf(String value) {
        switch (value) {
            case "CANCELED": {
                return CANCELED;
            }
            case "PROPOSED": {
                return PROPOSED;
            }
            case "COMPLETED": {
                return COMPLETED;
            }
            case "RESERVED": {
                return RESERVED;
            }
            case "PREPARED": {
                return PREPARED;
            }
            case "FAILED": {
                return FAILED;
            }
        }
        return new FulfillmentState(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitProposed();

        public T visitReserved();

        public T visitPrepared();

        public T visitCompleted();

        public T visitCanceled();

        public T visitFailed();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        PROPOSED,
        RESERVED,
        PREPARED,
        COMPLETED,
        CANCELED,
        FAILED,
        UNKNOWN;

    }
}

