/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetBankAccountsRequest {
    private final String bankAccountId;
    private final Map<String, Object> additionalProperties;

    private GetBankAccountsRequest(String bankAccountId, Map<String, Object> additionalProperties) {
        this.bankAccountId = bankAccountId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="bank_account_id")
    public String getBankAccountId() {
        return this.bankAccountId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetBankAccountsRequest && this.equalTo((GetBankAccountsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetBankAccountsRequest other) {
        return this.bankAccountId.equals(other.bankAccountId);
    }

    public int hashCode() {
        return Objects.hash(this.bankAccountId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BankAccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BankAccountIdStage,
    _FinalStage {
        private String bankAccountId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetBankAccountsRequest other) {
            this.bankAccountId(other.getBankAccountId());
            return this;
        }

        @Override
        @JsonSetter(value="bank_account_id")
        public _FinalStage bankAccountId(@NotNull String bankAccountId) {
            this.bankAccountId = Objects.requireNonNull(bankAccountId, "bankAccountId must not be null");
            return this;
        }

        @Override
        public GetBankAccountsRequest build() {
            return new GetBankAccountsRequest(this.bankAccountId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetBankAccountsRequest build();
    }

    public static interface BankAccountIdStage {
        public _FinalStage bankAccountId(@NotNull String var1);

        public Builder from(GetBankAccountsRequest var1);
    }
}

