/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Employee;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetEmployeeResponse {
    private final Optional<Employee> employee;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private GetEmployeeResponse(Optional<Employee> employee, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.employee = employee;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="employee")
    public Optional<Employee> getEmployee() {
        return this.employee;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetEmployeeResponse && this.equalTo((GetEmployeeResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetEmployeeResponse other) {
        return this.employee.equals(other.employee) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.employee, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Employee> employee = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetEmployeeResponse other) {
            this.employee(other.getEmployee());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="employee", nulls=Nulls.SKIP)
        public Builder employee(Optional<Employee> employee) {
            this.employee = employee;
            return this;
        }

        public Builder employee(Employee employee) {
            this.employee = Optional.ofNullable(employee);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public GetEmployeeResponse build() {
            return new GetEmployeeResponse(this.employee, this.errors, this.additionalProperties);
        }
    }
}

