/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.InventoryTransfer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetInventoryTransferResponse {
    private final Optional<List<Error>> errors;
    private final Optional<InventoryTransfer> transfer;
    private final Map<String, Object> additionalProperties;

    private GetInventoryTransferResponse(Optional<List<Error>> errors, Optional<InventoryTransfer> transfer, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.transfer = transfer;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="transfer")
    public Optional<InventoryTransfer> getTransfer() {
        return this.transfer;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetInventoryTransferResponse && this.equalTo((GetInventoryTransferResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetInventoryTransferResponse other) {
        return this.errors.equals(other.errors) && this.transfer.equals(other.transfer);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.transfer);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<InventoryTransfer> transfer = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetInventoryTransferResponse other) {
            this.errors(other.getErrors());
            this.transfer(other.getTransfer());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="transfer", nulls=Nulls.SKIP)
        public Builder transfer(Optional<InventoryTransfer> transfer) {
            this.transfer = transfer;
            return this;
        }

        public Builder transfer(InventoryTransfer transfer) {
            this.transfer = Optional.ofNullable(transfer);
            return this;
        }

        public GetInventoryTransferResponse build() {
            return new GetInventoryTransferResponse(this.errors, this.transfer, this.additionalProperties);
        }
    }
}

