/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.LoyaltyAccount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetLoyaltyAccountResponse {
    private final Optional<List<Error>> errors;
    private final Optional<LoyaltyAccount> loyaltyAccount;
    private final Map<String, Object> additionalProperties;

    private GetLoyaltyAccountResponse(Optional<List<Error>> errors, Optional<LoyaltyAccount> loyaltyAccount, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.loyaltyAccount = loyaltyAccount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="loyalty_account")
    public Optional<LoyaltyAccount> getLoyaltyAccount() {
        return this.loyaltyAccount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetLoyaltyAccountResponse && this.equalTo((GetLoyaltyAccountResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetLoyaltyAccountResponse other) {
        return this.errors.equals(other.errors) && this.loyaltyAccount.equals(other.loyaltyAccount);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.loyaltyAccount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<LoyaltyAccount> loyaltyAccount = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetLoyaltyAccountResponse other) {
            this.errors(other.getErrors());
            this.loyaltyAccount(other.getLoyaltyAccount());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="loyalty_account", nulls=Nulls.SKIP)
        public Builder loyaltyAccount(Optional<LoyaltyAccount> loyaltyAccount) {
            this.loyaltyAccount = loyaltyAccount;
            return this;
        }

        public Builder loyaltyAccount(LoyaltyAccount loyaltyAccount) {
            this.loyaltyAccount = Optional.ofNullable(loyaltyAccount);
            return this;
        }

        public GetLoyaltyAccountResponse build() {
            return new GetLoyaltyAccountResponse(this.errors, this.loyaltyAccount, this.additionalProperties);
        }
    }
}

