/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.LoyaltyReward;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetLoyaltyRewardResponse {
    private final Optional<List<Error>> errors;
    private final Optional<LoyaltyReward> reward;
    private final Map<String, Object> additionalProperties;

    private GetLoyaltyRewardResponse(Optional<List<Error>> errors, Optional<LoyaltyReward> reward, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.reward = reward;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="reward")
    public Optional<LoyaltyReward> getReward() {
        return this.reward;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetLoyaltyRewardResponse && this.equalTo((GetLoyaltyRewardResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetLoyaltyRewardResponse other) {
        return this.errors.equals(other.errors) && this.reward.equals(other.reward);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.reward);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<LoyaltyReward> reward = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetLoyaltyRewardResponse other) {
            this.errors(other.getErrors());
            this.reward(other.getReward());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="reward", nulls=Nulls.SKIP)
        public Builder reward(Optional<LoyaltyReward> reward) {
            this.reward = reward;
            return this;
        }

        public Builder reward(LoyaltyReward reward) {
            this.reward = Optional.ofNullable(reward);
            return this;
        }

        public GetLoyaltyRewardResponse build() {
            return new GetLoyaltyRewardResponse(this.errors, this.reward, this.additionalProperties);
        }
    }
}

