/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.PaymentLink;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetPaymentLinkResponse {
    private final Optional<List<Error>> errors;
    private final Optional<PaymentLink> paymentLink;
    private final Map<String, Object> additionalProperties;

    private GetPaymentLinkResponse(Optional<List<Error>> errors, Optional<PaymentLink> paymentLink, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.paymentLink = paymentLink;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="payment_link")
    public Optional<PaymentLink> getPaymentLink() {
        return this.paymentLink;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetPaymentLinkResponse && this.equalTo((GetPaymentLinkResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetPaymentLinkResponse other) {
        return this.errors.equals(other.errors) && this.paymentLink.equals(other.paymentLink);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.paymentLink);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<PaymentLink> paymentLink = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetPaymentLinkResponse other) {
            this.errors(other.getErrors());
            this.paymentLink(other.getPaymentLink());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="payment_link", nulls=Nulls.SKIP)
        public Builder paymentLink(Optional<PaymentLink> paymentLink) {
            this.paymentLink = paymentLink;
            return this;
        }

        public Builder paymentLink(PaymentLink paymentLink) {
            this.paymentLink = Optional.ofNullable(paymentLink);
            return this;
        }

        public GetPaymentLinkResponse build() {
            return new GetPaymentLinkResponse(this.errors, this.paymentLink, this.additionalProperties);
        }
    }
}

