/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetPayoutsRequest {
    private final String payoutId;
    private final Map<String, Object> additionalProperties;

    private GetPayoutsRequest(String payoutId, Map<String, Object> additionalProperties) {
        this.payoutId = payoutId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="payout_id")
    public String getPayoutId() {
        return this.payoutId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetPayoutsRequest && this.equalTo((GetPayoutsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetPayoutsRequest other) {
        return this.payoutId.equals(other.payoutId);
    }

    public int hashCode() {
        return Objects.hash(this.payoutId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PayoutIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PayoutIdStage,
    _FinalStage {
        private String payoutId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetPayoutsRequest other) {
            this.payoutId(other.getPayoutId());
            return this;
        }

        @Override
        @JsonSetter(value="payout_id")
        public _FinalStage payoutId(@NotNull String payoutId) {
            this.payoutId = Objects.requireNonNull(payoutId, "payoutId must not be null");
            return this;
        }

        @Override
        public GetPayoutsRequest build() {
            return new GetPayoutsRequest(this.payoutId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetPayoutsRequest build();
    }

    public static interface PayoutIdStage {
        public _FinalStage payoutId(@NotNull String var1);

        public Builder from(GetPayoutsRequest var1);
    }
}

