/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.WageSetting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetWageSettingResponse {
    private final Optional<WageSetting> wageSetting;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private GetWageSettingResponse(Optional<WageSetting> wageSetting, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.wageSetting = wageSetting;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="wage_setting")
    public Optional<WageSetting> getWageSetting() {
        return this.wageSetting;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetWageSettingResponse && this.equalTo((GetWageSettingResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetWageSettingResponse other) {
        return this.wageSetting.equals(other.wageSetting) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.wageSetting, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<WageSetting> wageSetting = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetWageSettingResponse other) {
            this.wageSetting(other.getWageSetting());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="wage_setting", nulls=Nulls.SKIP)
        public Builder wageSetting(Optional<WageSetting> wageSetting) {
            this.wageSetting = wageSetting;
            return this;
        }

        public Builder wageSetting(WageSetting wageSetting) {
            this.wageSetting = Optional.ofNullable(wageSetting);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public GetWageSettingResponse build() {
            return new GetWageSettingResponse(this.wageSetting, this.errors, this.additionalProperties);
        }
    }
}

