/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.GiftCard;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GiftCardUpdatedEventObject {
    private final Optional<GiftCard> giftCard;
    private final Map<String, Object> additionalProperties;

    private GiftCardUpdatedEventObject(Optional<GiftCard> giftCard, Map<String, Object> additionalProperties) {
        this.giftCard = giftCard;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="gift_card")
    public Optional<GiftCard> getGiftCard() {
        return this.giftCard;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GiftCardUpdatedEventObject && this.equalTo((GiftCardUpdatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GiftCardUpdatedEventObject other) {
        return this.giftCard.equals(other.giftCard);
    }

    public int hashCode() {
        return Objects.hash(this.giftCard);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<GiftCard> giftCard = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GiftCardUpdatedEventObject other) {
            this.giftCard(other.getGiftCard());
            return this;
        }

        @JsonSetter(value="gift_card", nulls=Nulls.SKIP)
        public Builder giftCard(Optional<GiftCard> giftCard) {
            this.giftCard = giftCard;
            return this;
        }

        public Builder giftCard(GiftCard giftCard) {
            this.giftCard = Optional.ofNullable(giftCard);
            return this;
        }

        public GiftCardUpdatedEventObject build() {
            return new GiftCardUpdatedEventObject(this.giftCard, this.additionalProperties);
        }
    }
}

