/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InventoryAdjustmentGroup;
import com.squareup.square.types.InventoryState;
import com.squareup.square.types.Money;
import com.squareup.square.types.SourceApplication;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InventoryAdjustment {
    private final Optional<String> id;
    private final Optional<String> referenceId;
    private final Optional<InventoryState> fromState;
    private final Optional<InventoryState> toState;
    private final Optional<String> locationId;
    private final Optional<String> catalogObjectId;
    private final Optional<String> catalogObjectType;
    private final Optional<String> quantity;
    private final Optional<Money> totalPriceMoney;
    private final Optional<String> occurredAt;
    private final Optional<String> createdAt;
    private final Optional<SourceApplication> source;
    private final Optional<String> employeeId;
    private final Optional<String> teamMemberId;
    private final Optional<String> transactionId;
    private final Optional<String> refundId;
    private final Optional<String> purchaseOrderId;
    private final Optional<String> goodsReceiptId;
    private final Optional<InventoryAdjustmentGroup> adjustmentGroup;
    private final Map<String, Object> additionalProperties;

    private InventoryAdjustment(Optional<String> id, Optional<String> referenceId, Optional<InventoryState> fromState, Optional<InventoryState> toState, Optional<String> locationId, Optional<String> catalogObjectId, Optional<String> catalogObjectType, Optional<String> quantity, Optional<Money> totalPriceMoney, Optional<String> occurredAt, Optional<String> createdAt, Optional<SourceApplication> source, Optional<String> employeeId, Optional<String> teamMemberId, Optional<String> transactionId, Optional<String> refundId, Optional<String> purchaseOrderId, Optional<String> goodsReceiptId, Optional<InventoryAdjustmentGroup> adjustmentGroup, Map<String, Object> additionalProperties) {
        this.id = id;
        this.referenceId = referenceId;
        this.fromState = fromState;
        this.toState = toState;
        this.locationId = locationId;
        this.catalogObjectId = catalogObjectId;
        this.catalogObjectType = catalogObjectType;
        this.quantity = quantity;
        this.totalPriceMoney = totalPriceMoney;
        this.occurredAt = occurredAt;
        this.createdAt = createdAt;
        this.source = source;
        this.employeeId = employeeId;
        this.teamMemberId = teamMemberId;
        this.transactionId = transactionId;
        this.refundId = refundId;
        this.purchaseOrderId = purchaseOrderId;
        this.goodsReceiptId = goodsReceiptId;
        this.adjustmentGroup = adjustmentGroup;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonProperty(value="from_state")
    public Optional<InventoryState> getFromState() {
        return this.fromState;
    }

    @JsonProperty(value="to_state")
    public Optional<InventoryState> getToState() {
        return this.toState;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectId() {
        if (this.catalogObjectId == null) {
            return Optional.empty();
        }
        return this.catalogObjectId;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectType() {
        if (this.catalogObjectType == null) {
            return Optional.empty();
        }
        return this.catalogObjectType;
    }

    @JsonIgnore
    public Optional<String> getQuantity() {
        if (this.quantity == null) {
            return Optional.empty();
        }
        return this.quantity;
    }

    @JsonProperty(value="total_price_money")
    public Optional<Money> getTotalPriceMoney() {
        return this.totalPriceMoney;
    }

    @JsonIgnore
    public Optional<String> getOccurredAt() {
        if (this.occurredAt == null) {
            return Optional.empty();
        }
        return this.occurredAt;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="source")
    public Optional<SourceApplication> getSource() {
        return this.source;
    }

    @JsonIgnore
    public Optional<String> getEmployeeId() {
        if (this.employeeId == null) {
            return Optional.empty();
        }
        return this.employeeId;
    }

    @JsonIgnore
    public Optional<String> getTeamMemberId() {
        if (this.teamMemberId == null) {
            return Optional.empty();
        }
        return this.teamMemberId;
    }

    @JsonProperty(value="transaction_id")
    public Optional<String> getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="refund_id")
    public Optional<String> getRefundId() {
        return this.refundId;
    }

    @JsonProperty(value="purchase_order_id")
    public Optional<String> getPurchaseOrderId() {
        return this.purchaseOrderId;
    }

    @JsonProperty(value="goods_receipt_id")
    public Optional<String> getGoodsReceiptId() {
        return this.goodsReceiptId;
    }

    @JsonProperty(value="adjustment_group")
    public Optional<InventoryAdjustmentGroup> getAdjustmentGroup() {
        return this.adjustmentGroup;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_id")
    private Optional<String> _getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_type")
    private Optional<String> _getCatalogObjectType() {
        return this.catalogObjectType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="quantity")
    private Optional<String> _getQuantity() {
        return this.quantity;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="occurred_at")
    private Optional<String> _getOccurredAt() {
        return this.occurredAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="employee_id")
    private Optional<String> _getEmployeeId() {
        return this.employeeId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_id")
    private Optional<String> _getTeamMemberId() {
        return this.teamMemberId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InventoryAdjustment && this.equalTo((InventoryAdjustment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InventoryAdjustment other) {
        return this.id.equals(other.id) && this.referenceId.equals(other.referenceId) && this.fromState.equals(other.fromState) && this.toState.equals(other.toState) && this.locationId.equals(other.locationId) && this.catalogObjectId.equals(other.catalogObjectId) && this.catalogObjectType.equals(other.catalogObjectType) && this.quantity.equals(other.quantity) && this.totalPriceMoney.equals(other.totalPriceMoney) && this.occurredAt.equals(other.occurredAt) && this.createdAt.equals(other.createdAt) && this.source.equals(other.source) && this.employeeId.equals(other.employeeId) && this.teamMemberId.equals(other.teamMemberId) && this.transactionId.equals(other.transactionId) && this.refundId.equals(other.refundId) && this.purchaseOrderId.equals(other.purchaseOrderId) && this.goodsReceiptId.equals(other.goodsReceiptId) && this.adjustmentGroup.equals(other.adjustmentGroup);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.referenceId, this.fromState, this.toState, this.locationId, this.catalogObjectId, this.catalogObjectType, this.quantity, this.totalPriceMoney, this.occurredAt, this.createdAt, this.source, this.employeeId, this.teamMemberId, this.transactionId, this.refundId, this.purchaseOrderId, this.goodsReceiptId, this.adjustmentGroup);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<InventoryState> fromState = Optional.empty();
        private Optional<InventoryState> toState = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> catalogObjectId = Optional.empty();
        private Optional<String> catalogObjectType = Optional.empty();
        private Optional<String> quantity = Optional.empty();
        private Optional<Money> totalPriceMoney = Optional.empty();
        private Optional<String> occurredAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<SourceApplication> source = Optional.empty();
        private Optional<String> employeeId = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<String> transactionId = Optional.empty();
        private Optional<String> refundId = Optional.empty();
        private Optional<String> purchaseOrderId = Optional.empty();
        private Optional<String> goodsReceiptId = Optional.empty();
        private Optional<InventoryAdjustmentGroup> adjustmentGroup = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InventoryAdjustment other) {
            this.id(other.getId());
            this.referenceId(other.getReferenceId());
            this.fromState(other.getFromState());
            this.toState(other.getToState());
            this.locationId(other.getLocationId());
            this.catalogObjectId(other.getCatalogObjectId());
            this.catalogObjectType(other.getCatalogObjectType());
            this.quantity(other.getQuantity());
            this.totalPriceMoney(other.getTotalPriceMoney());
            this.occurredAt(other.getOccurredAt());
            this.createdAt(other.getCreatedAt());
            this.source(other.getSource());
            this.employeeId(other.getEmployeeId());
            this.teamMemberId(other.getTeamMemberId());
            this.transactionId(other.getTransactionId());
            this.refundId(other.getRefundId());
            this.purchaseOrderId(other.getPurchaseOrderId());
            this.goodsReceiptId(other.getGoodsReceiptId());
            this.adjustmentGroup(other.getAdjustmentGroup());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        public Builder referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @JsonSetter(value="from_state", nulls=Nulls.SKIP)
        public Builder fromState(Optional<InventoryState> fromState) {
            this.fromState = fromState;
            return this;
        }

        public Builder fromState(InventoryState fromState) {
            this.fromState = Optional.ofNullable(fromState);
            return this;
        }

        @JsonSetter(value="to_state", nulls=Nulls.SKIP)
        public Builder toState(Optional<InventoryState> toState) {
            this.toState = toState;
            return this;
        }

        public Builder toState(InventoryState toState) {
            this.toState = Optional.ofNullable(toState);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="catalog_object_id", nulls=Nulls.SKIP)
        public Builder catalogObjectId(Optional<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = Optional.ofNullable(catalogObjectId);
            return this;
        }

        public Builder catalogObjectId(Nullable<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId.isNull() ? null : (catalogObjectId.isEmpty() ? Optional.empty() : Optional.of(catalogObjectId.get()));
            return this;
        }

        @JsonSetter(value="catalog_object_type", nulls=Nulls.SKIP)
        public Builder catalogObjectType(Optional<String> catalogObjectType) {
            this.catalogObjectType = catalogObjectType;
            return this;
        }

        public Builder catalogObjectType(String catalogObjectType) {
            this.catalogObjectType = Optional.ofNullable(catalogObjectType);
            return this;
        }

        public Builder catalogObjectType(Nullable<String> catalogObjectType) {
            this.catalogObjectType = catalogObjectType.isNull() ? null : (catalogObjectType.isEmpty() ? Optional.empty() : Optional.of(catalogObjectType.get()));
            return this;
        }

        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public Builder quantity(Optional<String> quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        public Builder quantity(Nullable<String> quantity) {
            this.quantity = quantity.isNull() ? null : (quantity.isEmpty() ? Optional.empty() : Optional.of(quantity.get()));
            return this;
        }

        @JsonSetter(value="total_price_money", nulls=Nulls.SKIP)
        public Builder totalPriceMoney(Optional<Money> totalPriceMoney) {
            this.totalPriceMoney = totalPriceMoney;
            return this;
        }

        public Builder totalPriceMoney(Money totalPriceMoney) {
            this.totalPriceMoney = Optional.ofNullable(totalPriceMoney);
            return this;
        }

        @JsonSetter(value="occurred_at", nulls=Nulls.SKIP)
        public Builder occurredAt(Optional<String> occurredAt) {
            this.occurredAt = occurredAt;
            return this;
        }

        public Builder occurredAt(String occurredAt) {
            this.occurredAt = Optional.ofNullable(occurredAt);
            return this;
        }

        public Builder occurredAt(Nullable<String> occurredAt) {
            this.occurredAt = occurredAt.isNull() ? null : (occurredAt.isEmpty() ? Optional.empty() : Optional.of(occurredAt.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public Builder source(Optional<SourceApplication> source) {
            this.source = source;
            return this;
        }

        public Builder source(SourceApplication source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        @JsonSetter(value="employee_id", nulls=Nulls.SKIP)
        public Builder employeeId(Optional<String> employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = Optional.ofNullable(employeeId);
            return this;
        }

        public Builder employeeId(Nullable<String> employeeId) {
            this.employeeId = employeeId.isNull() ? null : (employeeId.isEmpty() ? Optional.empty() : Optional.of(employeeId.get()));
            return this;
        }

        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public Builder teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        public Builder teamMemberId(Nullable<String> teamMemberId) {
            this.teamMemberId = teamMemberId.isNull() ? null : (teamMemberId.isEmpty() ? Optional.empty() : Optional.of(teamMemberId.get()));
            return this;
        }

        @JsonSetter(value="transaction_id", nulls=Nulls.SKIP)
        public Builder transactionId(Optional<String> transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = Optional.ofNullable(transactionId);
            return this;
        }

        @JsonSetter(value="refund_id", nulls=Nulls.SKIP)
        public Builder refundId(Optional<String> refundId) {
            this.refundId = refundId;
            return this;
        }

        public Builder refundId(String refundId) {
            this.refundId = Optional.ofNullable(refundId);
            return this;
        }

        @JsonSetter(value="purchase_order_id", nulls=Nulls.SKIP)
        public Builder purchaseOrderId(Optional<String> purchaseOrderId) {
            this.purchaseOrderId = purchaseOrderId;
            return this;
        }

        public Builder purchaseOrderId(String purchaseOrderId) {
            this.purchaseOrderId = Optional.ofNullable(purchaseOrderId);
            return this;
        }

        @JsonSetter(value="goods_receipt_id", nulls=Nulls.SKIP)
        public Builder goodsReceiptId(Optional<String> goodsReceiptId) {
            this.goodsReceiptId = goodsReceiptId;
            return this;
        }

        public Builder goodsReceiptId(String goodsReceiptId) {
            this.goodsReceiptId = Optional.ofNullable(goodsReceiptId);
            return this;
        }

        @JsonSetter(value="adjustment_group", nulls=Nulls.SKIP)
        public Builder adjustmentGroup(Optional<InventoryAdjustmentGroup> adjustmentGroup) {
            this.adjustmentGroup = adjustmentGroup;
            return this;
        }

        public Builder adjustmentGroup(InventoryAdjustmentGroup adjustmentGroup) {
            this.adjustmentGroup = Optional.ofNullable(adjustmentGroup);
            return this;
        }

        public InventoryAdjustment build() {
            return new InventoryAdjustment(this.id, this.referenceId, this.fromState, this.toState, this.locationId, this.catalogObjectId, this.catalogObjectType, this.quantity, this.totalPriceMoney, this.occurredAt, this.createdAt, this.source, this.employeeId, this.teamMemberId, this.transactionId, this.refundId, this.purchaseOrderId, this.goodsReceiptId, this.adjustmentGroup, this.additionalProperties);
        }
    }
}

