/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class InventoryAlertType {
    public static final InventoryAlertType LOW_QUANTITY = new InventoryAlertType(Value.LOW_QUANTITY, "LOW_QUANTITY");
    public static final InventoryAlertType NONE = new InventoryAlertType(Value.NONE, "NONE");
    private final Value value;
    private final String string;

    InventoryAlertType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof InventoryAlertType && this.string.equals(((InventoryAlertType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case LOW_QUANTITY: {
                return visitor.visitLowQuantity();
            }
            case NONE: {
                return visitor.visitNone();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static InventoryAlertType valueOf(String value) {
        switch (value) {
            case "LOW_QUANTITY": {
                return LOW_QUANTITY;
            }
            case "NONE": {
                return NONE;
            }
        }
        return new InventoryAlertType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitNone();

        public T visitLowQuantity();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        NONE,
        LOW_QUANTITY,
        UNKNOWN;

    }
}

