/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class InvoiceDeliveryMethod {
    public static final InvoiceDeliveryMethod SMS = new InvoiceDeliveryMethod(Value.SMS, "SMS");
    public static final InvoiceDeliveryMethod SHARE_MANUALLY = new InvoiceDeliveryMethod(Value.SHARE_MANUALLY, "SHARE_MANUALLY");
    public static final InvoiceDeliveryMethod EMAIL = new InvoiceDeliveryMethod(Value.EMAIL, "EMAIL");
    private final Value value;
    private final String string;

    InvoiceDeliveryMethod(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof InvoiceDeliveryMethod && this.string.equals(((InvoiceDeliveryMethod)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case SMS: {
                return visitor.visitSms();
            }
            case SHARE_MANUALLY: {
                return visitor.visitShareManually();
            }
            case EMAIL: {
                return visitor.visitEmail();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static InvoiceDeliveryMethod valueOf(String value) {
        switch (value) {
            case "SMS": {
                return SMS;
            }
            case "SHARE_MANUALLY": {
                return SHARE_MANUALLY;
            }
            case "EMAIL": {
                return EMAIL;
            }
        }
        return new InvoiceDeliveryMethod(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitEmail();

        public T visitShareManually();

        public T visitSms();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        EMAIL,
        SHARE_MANUALLY,
        SMS,
        UNKNOWN;

    }
}

