/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InvoicePaymentReminderStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InvoicePaymentReminder {
    private final Optional<String> uid;
    private final Optional<Integer> relativeScheduledDays;
    private final Optional<String> message;
    private final Optional<InvoicePaymentReminderStatus> status;
    private final Optional<String> sentAt;
    private final Map<String, Object> additionalProperties;

    private InvoicePaymentReminder(Optional<String> uid, Optional<Integer> relativeScheduledDays, Optional<String> message, Optional<InvoicePaymentReminderStatus> status, Optional<String> sentAt, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.relativeScheduledDays = relativeScheduledDays;
        this.message = message;
        this.status = status;
        this.sentAt = sentAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="uid")
    public Optional<String> getUid() {
        return this.uid;
    }

    @JsonIgnore
    public Optional<Integer> getRelativeScheduledDays() {
        if (this.relativeScheduledDays == null) {
            return Optional.empty();
        }
        return this.relativeScheduledDays;
    }

    @JsonIgnore
    public Optional<String> getMessage() {
        if (this.message == null) {
            return Optional.empty();
        }
        return this.message;
    }

    @JsonProperty(value="status")
    public Optional<InvoicePaymentReminderStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="sent_at")
    public Optional<String> getSentAt() {
        return this.sentAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="relative_scheduled_days")
    private Optional<Integer> _getRelativeScheduledDays() {
        return this.relativeScheduledDays;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="message")
    private Optional<String> _getMessage() {
        return this.message;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoicePaymentReminder && this.equalTo((InvoicePaymentReminder)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoicePaymentReminder other) {
        return this.uid.equals(other.uid) && this.relativeScheduledDays.equals(other.relativeScheduledDays) && this.message.equals(other.message) && this.status.equals(other.status) && this.sentAt.equals(other.sentAt);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.relativeScheduledDays, this.message, this.status, this.sentAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> uid = Optional.empty();
        private Optional<Integer> relativeScheduledDays = Optional.empty();
        private Optional<String> message = Optional.empty();
        private Optional<InvoicePaymentReminderStatus> status = Optional.empty();
        private Optional<String> sentAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InvoicePaymentReminder other) {
            this.uid(other.getUid());
            this.relativeScheduledDays(other.getRelativeScheduledDays());
            this.message(other.getMessage());
            this.status(other.getStatus());
            this.sentAt(other.getSentAt());
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        @JsonSetter(value="relative_scheduled_days", nulls=Nulls.SKIP)
        public Builder relativeScheduledDays(Optional<Integer> relativeScheduledDays) {
            this.relativeScheduledDays = relativeScheduledDays;
            return this;
        }

        public Builder relativeScheduledDays(Integer relativeScheduledDays) {
            this.relativeScheduledDays = Optional.ofNullable(relativeScheduledDays);
            return this;
        }

        public Builder relativeScheduledDays(Nullable<Integer> relativeScheduledDays) {
            this.relativeScheduledDays = relativeScheduledDays.isNull() ? null : (relativeScheduledDays.isEmpty() ? Optional.empty() : Optional.of(relativeScheduledDays.get()));
            return this;
        }

        @JsonSetter(value="message", nulls=Nulls.SKIP)
        public Builder message(Optional<String> message) {
            this.message = message;
            return this;
        }

        public Builder message(String message) {
            this.message = Optional.ofNullable(message);
            return this;
        }

        public Builder message(Nullable<String> message) {
            this.message = message.isNull() ? null : (message.isEmpty() ? Optional.empty() : Optional.of(message.get()));
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<InvoicePaymentReminderStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(InvoicePaymentReminderStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="sent_at", nulls=Nulls.SKIP)
        public Builder sentAt(Optional<String> sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        public Builder sentAt(String sentAt) {
            this.sentAt = Optional.ofNullable(sentAt);
            return this;
        }

        public InvoicePaymentReminder build() {
            return new InvoicePaymentReminder(this.uid, this.relativeScheduledDays, this.message, this.status, this.sentAt, this.additionalProperties);
        }
    }
}

