/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InvoiceAutomaticPaymentSource;
import com.squareup.square.types.InvoicePaymentReminder;
import com.squareup.square.types.InvoiceRequestMethod;
import com.squareup.square.types.InvoiceRequestType;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InvoicePaymentRequest {
    private final Optional<String> uid;
    private final Optional<InvoiceRequestMethod> requestMethod;
    private final Optional<InvoiceRequestType> requestType;
    private final Optional<String> dueDate;
    private final Optional<Money> fixedAmountRequestedMoney;
    private final Optional<String> percentageRequested;
    private final Optional<Boolean> tippingEnabled;
    private final Optional<InvoiceAutomaticPaymentSource> automaticPaymentSource;
    private final Optional<String> cardId;
    private final Optional<List<InvoicePaymentReminder>> reminders;
    private final Optional<Money> computedAmountMoney;
    private final Optional<Money> totalCompletedAmountMoney;
    private final Optional<Money> roundingAdjustmentIncludedMoney;
    private final Map<String, Object> additionalProperties;

    private InvoicePaymentRequest(Optional<String> uid, Optional<InvoiceRequestMethod> requestMethod, Optional<InvoiceRequestType> requestType, Optional<String> dueDate, Optional<Money> fixedAmountRequestedMoney, Optional<String> percentageRequested, Optional<Boolean> tippingEnabled, Optional<InvoiceAutomaticPaymentSource> automaticPaymentSource, Optional<String> cardId, Optional<List<InvoicePaymentReminder>> reminders, Optional<Money> computedAmountMoney, Optional<Money> totalCompletedAmountMoney, Optional<Money> roundingAdjustmentIncludedMoney, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.requestMethod = requestMethod;
        this.requestType = requestType;
        this.dueDate = dueDate;
        this.fixedAmountRequestedMoney = fixedAmountRequestedMoney;
        this.percentageRequested = percentageRequested;
        this.tippingEnabled = tippingEnabled;
        this.automaticPaymentSource = automaticPaymentSource;
        this.cardId = cardId;
        this.reminders = reminders;
        this.computedAmountMoney = computedAmountMoney;
        this.totalCompletedAmountMoney = totalCompletedAmountMoney;
        this.roundingAdjustmentIncludedMoney = roundingAdjustmentIncludedMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonProperty(value="request_method")
    public Optional<InvoiceRequestMethod> getRequestMethod() {
        return this.requestMethod;
    }

    @JsonProperty(value="request_type")
    public Optional<InvoiceRequestType> getRequestType() {
        return this.requestType;
    }

    @JsonIgnore
    public Optional<String> getDueDate() {
        if (this.dueDate == null) {
            return Optional.empty();
        }
        return this.dueDate;
    }

    @JsonProperty(value="fixed_amount_requested_money")
    public Optional<Money> getFixedAmountRequestedMoney() {
        return this.fixedAmountRequestedMoney;
    }

    @JsonIgnore
    public Optional<String> getPercentageRequested() {
        if (this.percentageRequested == null) {
            return Optional.empty();
        }
        return this.percentageRequested;
    }

    @JsonIgnore
    public Optional<Boolean> getTippingEnabled() {
        if (this.tippingEnabled == null) {
            return Optional.empty();
        }
        return this.tippingEnabled;
    }

    @JsonProperty(value="automatic_payment_source")
    public Optional<InvoiceAutomaticPaymentSource> getAutomaticPaymentSource() {
        return this.automaticPaymentSource;
    }

    @JsonIgnore
    public Optional<String> getCardId() {
        if (this.cardId == null) {
            return Optional.empty();
        }
        return this.cardId;
    }

    @JsonIgnore
    public Optional<List<InvoicePaymentReminder>> getReminders() {
        if (this.reminders == null) {
            return Optional.empty();
        }
        return this.reminders;
    }

    @JsonProperty(value="computed_amount_money")
    public Optional<Money> getComputedAmountMoney() {
        return this.computedAmountMoney;
    }

    @JsonProperty(value="total_completed_amount_money")
    public Optional<Money> getTotalCompletedAmountMoney() {
        return this.totalCompletedAmountMoney;
    }

    @JsonProperty(value="rounding_adjustment_included_money")
    public Optional<Money> getRoundingAdjustmentIncludedMoney() {
        return this.roundingAdjustmentIncludedMoney;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="due_date")
    private Optional<String> _getDueDate() {
        return this.dueDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="percentage_requested")
    private Optional<String> _getPercentageRequested() {
        return this.percentageRequested;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="tipping_enabled")
    private Optional<Boolean> _getTippingEnabled() {
        return this.tippingEnabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="card_id")
    private Optional<String> _getCardId() {
        return this.cardId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reminders")
    private Optional<List<InvoicePaymentReminder>> _getReminders() {
        return this.reminders;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoicePaymentRequest && this.equalTo((InvoicePaymentRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoicePaymentRequest other) {
        return this.uid.equals(other.uid) && this.requestMethod.equals(other.requestMethod) && this.requestType.equals(other.requestType) && this.dueDate.equals(other.dueDate) && this.fixedAmountRequestedMoney.equals(other.fixedAmountRequestedMoney) && this.percentageRequested.equals(other.percentageRequested) && this.tippingEnabled.equals(other.tippingEnabled) && this.automaticPaymentSource.equals(other.automaticPaymentSource) && this.cardId.equals(other.cardId) && this.reminders.equals(other.reminders) && this.computedAmountMoney.equals(other.computedAmountMoney) && this.totalCompletedAmountMoney.equals(other.totalCompletedAmountMoney) && this.roundingAdjustmentIncludedMoney.equals(other.roundingAdjustmentIncludedMoney);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.requestMethod, this.requestType, this.dueDate, this.fixedAmountRequestedMoney, this.percentageRequested, this.tippingEnabled, this.automaticPaymentSource, this.cardId, this.reminders, this.computedAmountMoney, this.totalCompletedAmountMoney, this.roundingAdjustmentIncludedMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> uid = Optional.empty();
        private Optional<InvoiceRequestMethod> requestMethod = Optional.empty();
        private Optional<InvoiceRequestType> requestType = Optional.empty();
        private Optional<String> dueDate = Optional.empty();
        private Optional<Money> fixedAmountRequestedMoney = Optional.empty();
        private Optional<String> percentageRequested = Optional.empty();
        private Optional<Boolean> tippingEnabled = Optional.empty();
        private Optional<InvoiceAutomaticPaymentSource> automaticPaymentSource = Optional.empty();
        private Optional<String> cardId = Optional.empty();
        private Optional<List<InvoicePaymentReminder>> reminders = Optional.empty();
        private Optional<Money> computedAmountMoney = Optional.empty();
        private Optional<Money> totalCompletedAmountMoney = Optional.empty();
        private Optional<Money> roundingAdjustmentIncludedMoney = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InvoicePaymentRequest other) {
            this.uid(other.getUid());
            this.requestMethod(other.getRequestMethod());
            this.requestType(other.getRequestType());
            this.dueDate(other.getDueDate());
            this.fixedAmountRequestedMoney(other.getFixedAmountRequestedMoney());
            this.percentageRequested(other.getPercentageRequested());
            this.tippingEnabled(other.getTippingEnabled());
            this.automaticPaymentSource(other.getAutomaticPaymentSource());
            this.cardId(other.getCardId());
            this.reminders(other.getReminders());
            this.computedAmountMoney(other.getComputedAmountMoney());
            this.totalCompletedAmountMoney(other.getTotalCompletedAmountMoney());
            this.roundingAdjustmentIncludedMoney(other.getRoundingAdjustmentIncludedMoney());
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        public Builder uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @JsonSetter(value="request_method", nulls=Nulls.SKIP)
        public Builder requestMethod(Optional<InvoiceRequestMethod> requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder requestMethod(InvoiceRequestMethod requestMethod) {
            this.requestMethod = Optional.ofNullable(requestMethod);
            return this;
        }

        @JsonSetter(value="request_type", nulls=Nulls.SKIP)
        public Builder requestType(Optional<InvoiceRequestType> requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder requestType(InvoiceRequestType requestType) {
            this.requestType = Optional.ofNullable(requestType);
            return this;
        }

        @JsonSetter(value="due_date", nulls=Nulls.SKIP)
        public Builder dueDate(Optional<String> dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public Builder dueDate(String dueDate) {
            this.dueDate = Optional.ofNullable(dueDate);
            return this;
        }

        public Builder dueDate(Nullable<String> dueDate) {
            this.dueDate = dueDate.isNull() ? null : (dueDate.isEmpty() ? Optional.empty() : Optional.of(dueDate.get()));
            return this;
        }

        @JsonSetter(value="fixed_amount_requested_money", nulls=Nulls.SKIP)
        public Builder fixedAmountRequestedMoney(Optional<Money> fixedAmountRequestedMoney) {
            this.fixedAmountRequestedMoney = fixedAmountRequestedMoney;
            return this;
        }

        public Builder fixedAmountRequestedMoney(Money fixedAmountRequestedMoney) {
            this.fixedAmountRequestedMoney = Optional.ofNullable(fixedAmountRequestedMoney);
            return this;
        }

        @JsonSetter(value="percentage_requested", nulls=Nulls.SKIP)
        public Builder percentageRequested(Optional<String> percentageRequested) {
            this.percentageRequested = percentageRequested;
            return this;
        }

        public Builder percentageRequested(String percentageRequested) {
            this.percentageRequested = Optional.ofNullable(percentageRequested);
            return this;
        }

        public Builder percentageRequested(Nullable<String> percentageRequested) {
            this.percentageRequested = percentageRequested.isNull() ? null : (percentageRequested.isEmpty() ? Optional.empty() : Optional.of(percentageRequested.get()));
            return this;
        }

        @JsonSetter(value="tipping_enabled", nulls=Nulls.SKIP)
        public Builder tippingEnabled(Optional<Boolean> tippingEnabled) {
            this.tippingEnabled = tippingEnabled;
            return this;
        }

        public Builder tippingEnabled(Boolean tippingEnabled) {
            this.tippingEnabled = Optional.ofNullable(tippingEnabled);
            return this;
        }

        public Builder tippingEnabled(Nullable<Boolean> tippingEnabled) {
            this.tippingEnabled = tippingEnabled.isNull() ? null : (tippingEnabled.isEmpty() ? Optional.empty() : Optional.of(tippingEnabled.get()));
            return this;
        }

        @JsonSetter(value="automatic_payment_source", nulls=Nulls.SKIP)
        public Builder automaticPaymentSource(Optional<InvoiceAutomaticPaymentSource> automaticPaymentSource) {
            this.automaticPaymentSource = automaticPaymentSource;
            return this;
        }

        public Builder automaticPaymentSource(InvoiceAutomaticPaymentSource automaticPaymentSource) {
            this.automaticPaymentSource = Optional.ofNullable(automaticPaymentSource);
            return this;
        }

        @JsonSetter(value="card_id", nulls=Nulls.SKIP)
        public Builder cardId(Optional<String> cardId) {
            this.cardId = cardId;
            return this;
        }

        public Builder cardId(String cardId) {
            this.cardId = Optional.ofNullable(cardId);
            return this;
        }

        public Builder cardId(Nullable<String> cardId) {
            this.cardId = cardId.isNull() ? null : (cardId.isEmpty() ? Optional.empty() : Optional.of(cardId.get()));
            return this;
        }

        @JsonSetter(value="reminders", nulls=Nulls.SKIP)
        public Builder reminders(Optional<List<InvoicePaymentReminder>> reminders) {
            this.reminders = reminders;
            return this;
        }

        public Builder reminders(List<InvoicePaymentReminder> reminders) {
            this.reminders = Optional.ofNullable(reminders);
            return this;
        }

        public Builder reminders(Nullable<List<InvoicePaymentReminder>> reminders) {
            this.reminders = reminders.isNull() ? null : (reminders.isEmpty() ? Optional.empty() : Optional.of(reminders.get()));
            return this;
        }

        @JsonSetter(value="computed_amount_money", nulls=Nulls.SKIP)
        public Builder computedAmountMoney(Optional<Money> computedAmountMoney) {
            this.computedAmountMoney = computedAmountMoney;
            return this;
        }

        public Builder computedAmountMoney(Money computedAmountMoney) {
            this.computedAmountMoney = Optional.ofNullable(computedAmountMoney);
            return this;
        }

        @JsonSetter(value="total_completed_amount_money", nulls=Nulls.SKIP)
        public Builder totalCompletedAmountMoney(Optional<Money> totalCompletedAmountMoney) {
            this.totalCompletedAmountMoney = totalCompletedAmountMoney;
            return this;
        }

        public Builder totalCompletedAmountMoney(Money totalCompletedAmountMoney) {
            this.totalCompletedAmountMoney = Optional.ofNullable(totalCompletedAmountMoney);
            return this;
        }

        @JsonSetter(value="rounding_adjustment_included_money", nulls=Nulls.SKIP)
        public Builder roundingAdjustmentIncludedMoney(Optional<Money> roundingAdjustmentIncludedMoney) {
            this.roundingAdjustmentIncludedMoney = roundingAdjustmentIncludedMoney;
            return this;
        }

        public Builder roundingAdjustmentIncludedMoney(Money roundingAdjustmentIncludedMoney) {
            this.roundingAdjustmentIncludedMoney = Optional.ofNullable(roundingAdjustmentIncludedMoney);
            return this;
        }

        public InvoicePaymentRequest build() {
            return new InvoicePaymentRequest(this.uid, this.requestMethod, this.requestType, this.dueDate, this.fixedAmountRequestedMoney, this.percentageRequested, this.tippingEnabled, this.automaticPaymentSource, this.cardId, this.reminders, this.computedAmountMoney, this.totalCompletedAmountMoney, this.roundingAdjustmentIncludedMoney, this.additionalProperties);
        }
    }
}

