/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InvoiceFilter;
import com.squareup.square.types.InvoiceSort;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceQuery {
    private final InvoiceFilter filter;
    private final Optional<InvoiceSort> sort;
    private final Map<String, Object> additionalProperties;

    private InvoiceQuery(InvoiceFilter filter, Optional<InvoiceSort> sort, Map<String, Object> additionalProperties) {
        this.filter = filter;
        this.sort = sort;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="filter")
    public InvoiceFilter getFilter() {
        return this.filter;
    }

    @JsonProperty(value="sort")
    public Optional<InvoiceSort> getSort() {
        return this.sort;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceQuery && this.equalTo((InvoiceQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceQuery other) {
        return this.filter.equals(other.filter) && this.sort.equals(other.sort);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FilterStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements FilterStage,
    _FinalStage {
        private InvoiceFilter filter;
        private Optional<InvoiceSort> sort = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(InvoiceQuery other) {
            this.filter(other.getFilter());
            this.sort(other.getSort());
            return this;
        }

        @Override
        @JsonSetter(value="filter")
        public _FinalStage filter(@NotNull InvoiceFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter must not be null");
            return this;
        }

        @Override
        public _FinalStage sort(InvoiceSort sort) {
            this.sort = Optional.ofNullable(sort);
            return this;
        }

        @Override
        @JsonSetter(value="sort", nulls=Nulls.SKIP)
        public _FinalStage sort(Optional<InvoiceSort> sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public InvoiceQuery build() {
            return new InvoiceQuery(this.filter, this.sort, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public InvoiceQuery build();

        public _FinalStage sort(Optional<InvoiceSort> var1);

        public _FinalStage sort(InvoiceSort var1);
    }

    public static interface FilterStage {
        public _FinalStage filter(@NotNull InvoiceFilter var1);

        public Builder from(InvoiceQuery var1);
    }
}

