/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.JobAssignmentPayType;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class JobAssignment {
    private final Optional<String> jobTitle;
    private final JobAssignmentPayType payType;
    private final Optional<Money> hourlyRate;
    private final Optional<Money> annualRate;
    private final Optional<Integer> weeklyHours;
    private final Optional<String> jobId;
    private final Map<String, Object> additionalProperties;

    private JobAssignment(Optional<String> jobTitle, JobAssignmentPayType payType, Optional<Money> hourlyRate, Optional<Money> annualRate, Optional<Integer> weeklyHours, Optional<String> jobId, Map<String, Object> additionalProperties) {
        this.jobTitle = jobTitle;
        this.payType = payType;
        this.hourlyRate = hourlyRate;
        this.annualRate = annualRate;
        this.weeklyHours = weeklyHours;
        this.jobId = jobId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getJobTitle() {
        if (this.jobTitle == null) {
            return Optional.empty();
        }
        return this.jobTitle;
    }

    @JsonProperty(value="pay_type")
    public JobAssignmentPayType getPayType() {
        return this.payType;
    }

    @JsonProperty(value="hourly_rate")
    public Optional<Money> getHourlyRate() {
        return this.hourlyRate;
    }

    @JsonProperty(value="annual_rate")
    public Optional<Money> getAnnualRate() {
        return this.annualRate;
    }

    @JsonIgnore
    public Optional<Integer> getWeeklyHours() {
        if (this.weeklyHours == null) {
            return Optional.empty();
        }
        return this.weeklyHours;
    }

    @JsonIgnore
    public Optional<String> getJobId() {
        if (this.jobId == null) {
            return Optional.empty();
        }
        return this.jobId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="job_title")
    private Optional<String> _getJobTitle() {
        return this.jobTitle;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="weekly_hours")
    private Optional<Integer> _getWeeklyHours() {
        return this.weeklyHours;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="job_id")
    private Optional<String> _getJobId() {
        return this.jobId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JobAssignment && this.equalTo((JobAssignment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(JobAssignment other) {
        return this.jobTitle.equals(other.jobTitle) && this.payType.equals(other.payType) && this.hourlyRate.equals(other.hourlyRate) && this.annualRate.equals(other.annualRate) && this.weeklyHours.equals(other.weeklyHours) && this.jobId.equals(other.jobId);
    }

    public int hashCode() {
        return Objects.hash(this.jobTitle, this.payType, this.hourlyRate, this.annualRate, this.weeklyHours, this.jobId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PayTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PayTypeStage,
    _FinalStage {
        private JobAssignmentPayType payType;
        private Optional<String> jobId = Optional.empty();
        private Optional<Integer> weeklyHours = Optional.empty();
        private Optional<Money> annualRate = Optional.empty();
        private Optional<Money> hourlyRate = Optional.empty();
        private Optional<String> jobTitle = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(JobAssignment other) {
            this.jobTitle(other.getJobTitle());
            this.payType(other.getPayType());
            this.hourlyRate(other.getHourlyRate());
            this.annualRate(other.getAnnualRate());
            this.weeklyHours(other.getWeeklyHours());
            this.jobId(other.getJobId());
            return this;
        }

        @Override
        @JsonSetter(value="pay_type")
        public _FinalStage payType(@NotNull JobAssignmentPayType payType) {
            this.payType = Objects.requireNonNull(payType, "payType must not be null");
            return this;
        }

        @Override
        public _FinalStage jobId(Nullable<String> jobId) {
            this.jobId = jobId.isNull() ? null : (jobId.isEmpty() ? Optional.empty() : Optional.of(jobId.get()));
            return this;
        }

        @Override
        public _FinalStage jobId(String jobId) {
            this.jobId = Optional.ofNullable(jobId);
            return this;
        }

        @Override
        @JsonSetter(value="job_id", nulls=Nulls.SKIP)
        public _FinalStage jobId(Optional<String> jobId) {
            this.jobId = jobId;
            return this;
        }

        @Override
        public _FinalStage weeklyHours(Nullable<Integer> weeklyHours) {
            this.weeklyHours = weeklyHours.isNull() ? null : (weeklyHours.isEmpty() ? Optional.empty() : Optional.of(weeklyHours.get()));
            return this;
        }

        @Override
        public _FinalStage weeklyHours(Integer weeklyHours) {
            this.weeklyHours = Optional.ofNullable(weeklyHours);
            return this;
        }

        @Override
        @JsonSetter(value="weekly_hours", nulls=Nulls.SKIP)
        public _FinalStage weeklyHours(Optional<Integer> weeklyHours) {
            this.weeklyHours = weeklyHours;
            return this;
        }

        @Override
        public _FinalStage annualRate(Money annualRate) {
            this.annualRate = Optional.ofNullable(annualRate);
            return this;
        }

        @Override
        @JsonSetter(value="annual_rate", nulls=Nulls.SKIP)
        public _FinalStage annualRate(Optional<Money> annualRate) {
            this.annualRate = annualRate;
            return this;
        }

        @Override
        public _FinalStage hourlyRate(Money hourlyRate) {
            this.hourlyRate = Optional.ofNullable(hourlyRate);
            return this;
        }

        @Override
        @JsonSetter(value="hourly_rate", nulls=Nulls.SKIP)
        public _FinalStage hourlyRate(Optional<Money> hourlyRate) {
            this.hourlyRate = hourlyRate;
            return this;
        }

        @Override
        public _FinalStage jobTitle(Nullable<String> jobTitle) {
            this.jobTitle = jobTitle.isNull() ? null : (jobTitle.isEmpty() ? Optional.empty() : Optional.of(jobTitle.get()));
            return this;
        }

        @Override
        public _FinalStage jobTitle(String jobTitle) {
            this.jobTitle = Optional.ofNullable(jobTitle);
            return this;
        }

        @Override
        @JsonSetter(value="job_title", nulls=Nulls.SKIP)
        public _FinalStage jobTitle(Optional<String> jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        @Override
        public JobAssignment build() {
            return new JobAssignment(this.jobTitle, this.payType, this.hourlyRate, this.annualRate, this.weeklyHours, this.jobId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public JobAssignment build();

        public _FinalStage jobTitle(Optional<String> var1);

        public _FinalStage jobTitle(String var1);

        public _FinalStage jobTitle(Nullable<String> var1);

        public _FinalStage hourlyRate(Optional<Money> var1);

        public _FinalStage hourlyRate(Money var1);

        public _FinalStage annualRate(Optional<Money> var1);

        public _FinalStage annualRate(Money var1);

        public _FinalStage weeklyHours(Optional<Integer> var1);

        public _FinalStage weeklyHours(Integer var1);

        public _FinalStage weeklyHours(Nullable<Integer> var1);

        public _FinalStage jobId(Optional<String> var1);

        public _FinalStage jobId(String var1);

        public _FinalStage jobId(Nullable<String> var1);
    }

    public static interface PayTypeStage {
        public _FinalStage payType(@NotNull JobAssignmentPayType var1);

        public Builder from(JobAssignment var1);
    }
}

