/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CashDrawerShiftEvent;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCashDrawerShiftEventsResponse {
    private final Optional<String> cursor;
    private final Optional<List<Error>> errors;
    private final Optional<List<CashDrawerShiftEvent>> cashDrawerShiftEvents;
    private final Map<String, Object> additionalProperties;

    private ListCashDrawerShiftEventsResponse(Optional<String> cursor, Optional<List<Error>> errors, Optional<List<CashDrawerShiftEvent>> cashDrawerShiftEvents, Map<String, Object> additionalProperties) {
        this.cursor = cursor;
        this.errors = errors;
        this.cashDrawerShiftEvents = cashDrawerShiftEvents;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="cash_drawer_shift_events")
    public Optional<List<CashDrawerShiftEvent>> getCashDrawerShiftEvents() {
        return this.cashDrawerShiftEvents;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCashDrawerShiftEventsResponse && this.equalTo((ListCashDrawerShiftEventsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCashDrawerShiftEventsResponse other) {
        return this.cursor.equals(other.cursor) && this.errors.equals(other.errors) && this.cashDrawerShiftEvents.equals(other.cashDrawerShiftEvents);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.errors, this.cashDrawerShiftEvents);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> cursor = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<CashDrawerShiftEvent>> cashDrawerShiftEvents = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListCashDrawerShiftEventsResponse other) {
            this.cursor(other.getCursor());
            this.errors(other.getErrors());
            this.cashDrawerShiftEvents(other.getCashDrawerShiftEvents());
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="cash_drawer_shift_events", nulls=Nulls.SKIP)
        public Builder cashDrawerShiftEvents(Optional<List<CashDrawerShiftEvent>> cashDrawerShiftEvents) {
            this.cashDrawerShiftEvents = cashDrawerShiftEvents;
            return this;
        }

        public Builder cashDrawerShiftEvents(List<CashDrawerShiftEvent> cashDrawerShiftEvents) {
            this.cashDrawerShiftEvents = Optional.ofNullable(cashDrawerShiftEvents);
            return this;
        }

        public ListCashDrawerShiftEventsResponse build() {
            return new ListCashDrawerShiftEventsResponse(this.cursor, this.errors, this.cashDrawerShiftEvents, this.additionalProperties);
        }
    }
}

