/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomAttribute;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCustomerCustomAttributesResponse {
    private final Optional<List<CustomAttribute>> customAttributes;
    private final Optional<String> cursor;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private ListCustomerCustomAttributesResponse(Optional<List<CustomAttribute>> customAttributes, Optional<String> cursor, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.customAttributes = customAttributes;
        this.cursor = cursor;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<List<CustomAttribute>> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCustomerCustomAttributesResponse && this.equalTo((ListCustomerCustomAttributesResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCustomerCustomAttributesResponse other) {
        return this.customAttributes.equals(other.customAttributes) && this.cursor.equals(other.cursor) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.customAttributes, this.cursor, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<CustomAttribute>> customAttributes = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListCustomerCustomAttributesResponse other) {
            this.customAttributes(other.getCustomAttributes());
            this.cursor(other.getCursor());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public Builder customAttributes(Optional<List<CustomAttribute>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public Builder customAttributes(List<CustomAttribute> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public ListCustomerCustomAttributesResponse build() {
            return new ListCustomerCustomAttributesResponse(this.customAttributes, this.cursor, this.errors, this.additionalProperties);
        }
    }
}

