/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerSortField;
import com.squareup.square.types.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCustomersRequest {
    private final Optional<String> cursor;
    private final Optional<Integer> limit;
    private final Optional<CustomerSortField> sortField;
    private final Optional<SortOrder> sortOrder;
    private final Optional<Boolean> count;
    private final Map<String, Object> additionalProperties;

    private ListCustomersRequest(Optional<String> cursor, Optional<Integer> limit, Optional<CustomerSortField> sortField, Optional<SortOrder> sortOrder, Optional<Boolean> count, Map<String, Object> additionalProperties) {
        this.cursor = cursor;
        this.limit = limit;
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.count = count;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonIgnore
    public Optional<CustomerSortField> getSortField() {
        if (this.sortField == null) {
            return Optional.empty();
        }
        return this.sortField;
    }

    @JsonIgnore
    public Optional<SortOrder> getSortOrder() {
        if (this.sortOrder == null) {
            return Optional.empty();
        }
        return this.sortOrder;
    }

    @JsonIgnore
    public Optional<Boolean> getCount() {
        if (this.count == null) {
            return Optional.empty();
        }
        return this.count;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_field")
    private Optional<CustomerSortField> _getSortField() {
        return this.sortField;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_order")
    private Optional<SortOrder> _getSortOrder() {
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="count")
    private Optional<Boolean> _getCount() {
        return this.count;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCustomersRequest && this.equalTo((ListCustomersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCustomersRequest other) {
        return this.cursor.equals(other.cursor) && this.limit.equals(other.limit) && this.sortField.equals(other.sortField) && this.sortOrder.equals(other.sortOrder) && this.count.equals(other.count);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit, this.sortField, this.sortOrder, this.count);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<CustomerSortField> sortField = Optional.empty();
        private Optional<SortOrder> sortOrder = Optional.empty();
        private Optional<Boolean> count = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListCustomersRequest other) {
            this.cursor(other.getCursor());
            this.limit(other.getLimit());
            this.sortField(other.getSortField());
            this.sortOrder(other.getSortOrder());
            this.count(other.getCount());
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @JsonSetter(value="sort_field", nulls=Nulls.SKIP)
        public Builder sortField(Optional<CustomerSortField> sortField) {
            this.sortField = sortField;
            return this;
        }

        public Builder sortField(CustomerSortField sortField) {
            this.sortField = Optional.ofNullable(sortField);
            return this;
        }

        public Builder sortField(Nullable<CustomerSortField> sortField) {
            this.sortField = sortField.isNull() ? null : (sortField.isEmpty() ? Optional.empty() : Optional.of(sortField.get()));
            return this;
        }

        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public Builder sortOrder(Optional<SortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        public Builder sortOrder(Nullable<SortOrder> sortOrder) {
            this.sortOrder = sortOrder.isNull() ? null : (sortOrder.isEmpty() ? Optional.empty() : Optional.of(sortOrder.get()));
            return this;
        }

        @JsonSetter(value="count", nulls=Nulls.SKIP)
        public Builder count(Optional<Boolean> count) {
            this.count = count;
            return this;
        }

        public Builder count(Boolean count) {
            this.count = Optional.ofNullable(count);
            return this;
        }

        public Builder count(Nullable<Boolean> count) {
            this.count = count.isNull() ? null : (count.isEmpty() ? Optional.empty() : Optional.of(count.get()));
            return this;
        }

        public ListCustomersRequest build() {
            return new ListCustomersRequest(this.cursor, this.limit, this.sortField, this.sortOrder, this.count, this.additionalProperties);
        }
    }
}

