/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DisputeEvidence;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListDisputeEvidenceResponse {
    private final Optional<List<DisputeEvidence>> evidence;
    private final Optional<List<Error>> errors;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private ListDisputeEvidenceResponse(Optional<List<DisputeEvidence>> evidence, Optional<List<Error>> errors, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.evidence = evidence;
        this.errors = errors;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="evidence")
    public Optional<List<DisputeEvidence>> getEvidence() {
        return this.evidence;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListDisputeEvidenceResponse && this.equalTo((ListDisputeEvidenceResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListDisputeEvidenceResponse other) {
        return this.evidence.equals(other.evidence) && this.errors.equals(other.errors) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.evidence, this.errors, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<DisputeEvidence>> evidence = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListDisputeEvidenceResponse other) {
            this.evidence(other.getEvidence());
            this.errors(other.getErrors());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="evidence", nulls=Nulls.SKIP)
        public Builder evidence(Optional<List<DisputeEvidence>> evidence) {
            this.evidence = evidence;
            return this;
        }

        public Builder evidence(List<DisputeEvidence> evidence) {
            this.evidence = Optional.ofNullable(evidence);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public ListDisputeEvidenceResponse build() {
            return new ListDisputeEvidenceResponse(this.evidence, this.errors, this.cursor, this.additionalProperties);
        }
    }
}

