/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.PaymentRefund;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListPaymentRefundsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<PaymentRefund>> refunds;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private ListPaymentRefundsResponse(Optional<List<Error>> errors, Optional<List<PaymentRefund>> refunds, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.refunds = refunds;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="refunds")
    public Optional<List<PaymentRefund>> getRefunds() {
        return this.refunds;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListPaymentRefundsResponse && this.equalTo((ListPaymentRefundsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListPaymentRefundsResponse other) {
        return this.errors.equals(other.errors) && this.refunds.equals(other.refunds) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.refunds, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<PaymentRefund>> refunds = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListPaymentRefundsResponse other) {
            this.errors(other.getErrors());
            this.refunds(other.getRefunds());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="refunds", nulls=Nulls.SKIP)
        public Builder refunds(Optional<List<PaymentRefund>> refunds) {
            this.refunds = refunds;
            return this;
        }

        public Builder refunds(List<PaymentRefund> refunds) {
            this.refunds = Optional.ofNullable(refunds);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public ListPaymentRefundsResponse build() {
            return new ListPaymentRefundsResponse(this.errors, this.refunds, this.cursor, this.additionalProperties);
        }
    }
}

