/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ListPaymentsRequestSortField;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListPaymentsRequest {
    private final Optional<String> beginTime;
    private final Optional<String> endTime;
    private final Optional<String> sortOrder;
    private final Optional<String> cursor;
    private final Optional<String> locationId;
    private final Optional<Long> total;
    private final Optional<String> last4;
    private final Optional<String> cardBrand;
    private final Optional<Integer> limit;
    private final Optional<Boolean> isOfflinePayment;
    private final Optional<String> offlineBeginTime;
    private final Optional<String> offlineEndTime;
    private final Optional<String> updatedAtBeginTime;
    private final Optional<String> updatedAtEndTime;
    private final Optional<ListPaymentsRequestSortField> sortField;
    private final Map<String, Object> additionalProperties;

    private ListPaymentsRequest(Optional<String> beginTime, Optional<String> endTime, Optional<String> sortOrder, Optional<String> cursor, Optional<String> locationId, Optional<Long> total, Optional<String> last4, Optional<String> cardBrand, Optional<Integer> limit, Optional<Boolean> isOfflinePayment, Optional<String> offlineBeginTime, Optional<String> offlineEndTime, Optional<String> updatedAtBeginTime, Optional<String> updatedAtEndTime, Optional<ListPaymentsRequestSortField> sortField, Map<String, Object> additionalProperties) {
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.sortOrder = sortOrder;
        this.cursor = cursor;
        this.locationId = locationId;
        this.total = total;
        this.last4 = last4;
        this.cardBrand = cardBrand;
        this.limit = limit;
        this.isOfflinePayment = isOfflinePayment;
        this.offlineBeginTime = offlineBeginTime;
        this.offlineEndTime = offlineEndTime;
        this.updatedAtBeginTime = updatedAtBeginTime;
        this.updatedAtEndTime = updatedAtEndTime;
        this.sortField = sortField;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getBeginTime() {
        if (this.beginTime == null) {
            return Optional.empty();
        }
        return this.beginTime;
    }

    @JsonIgnore
    public Optional<String> getEndTime() {
        if (this.endTime == null) {
            return Optional.empty();
        }
        return this.endTime;
    }

    @JsonIgnore
    public Optional<String> getSortOrder() {
        if (this.sortOrder == null) {
            return Optional.empty();
        }
        return this.sortOrder;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<Long> getTotal() {
        if (this.total == null) {
            return Optional.empty();
        }
        return this.total;
    }

    @JsonIgnore
    public Optional<String> getLast4() {
        if (this.last4 == null) {
            return Optional.empty();
        }
        return this.last4;
    }

    @JsonIgnore
    public Optional<String> getCardBrand() {
        if (this.cardBrand == null) {
            return Optional.empty();
        }
        return this.cardBrand;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonIgnore
    public Optional<Boolean> getIsOfflinePayment() {
        if (this.isOfflinePayment == null) {
            return Optional.empty();
        }
        return this.isOfflinePayment;
    }

    @JsonIgnore
    public Optional<String> getOfflineBeginTime() {
        if (this.offlineBeginTime == null) {
            return Optional.empty();
        }
        return this.offlineBeginTime;
    }

    @JsonIgnore
    public Optional<String> getOfflineEndTime() {
        if (this.offlineEndTime == null) {
            return Optional.empty();
        }
        return this.offlineEndTime;
    }

    @JsonIgnore
    public Optional<String> getUpdatedAtBeginTime() {
        if (this.updatedAtBeginTime == null) {
            return Optional.empty();
        }
        return this.updatedAtBeginTime;
    }

    @JsonIgnore
    public Optional<String> getUpdatedAtEndTime() {
        if (this.updatedAtEndTime == null) {
            return Optional.empty();
        }
        return this.updatedAtEndTime;
    }

    @JsonIgnore
    public Optional<ListPaymentsRequestSortField> getSortField() {
        if (this.sortField == null) {
            return Optional.empty();
        }
        return this.sortField;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="begin_time")
    private Optional<String> _getBeginTime() {
        return this.beginTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_time")
    private Optional<String> _getEndTime() {
        return this.endTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_order")
    private Optional<String> _getSortOrder() {
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="total")
    private Optional<Long> _getTotal() {
        return this.total;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_4")
    private Optional<String> _getLast4() {
        return this.last4;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="card_brand")
    private Optional<String> _getCardBrand() {
        return this.cardBrand;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_offline_payment")
    private Optional<Boolean> _getIsOfflinePayment() {
        return this.isOfflinePayment;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="offline_begin_time")
    private Optional<String> _getOfflineBeginTime() {
        return this.offlineBeginTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="offline_end_time")
    private Optional<String> _getOfflineEndTime() {
        return this.offlineEndTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="updated_at_begin_time")
    private Optional<String> _getUpdatedAtBeginTime() {
        return this.updatedAtBeginTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="updated_at_end_time")
    private Optional<String> _getUpdatedAtEndTime() {
        return this.updatedAtEndTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_field")
    private Optional<ListPaymentsRequestSortField> _getSortField() {
        return this.sortField;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListPaymentsRequest && this.equalTo((ListPaymentsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListPaymentsRequest other) {
        return this.beginTime.equals(other.beginTime) && this.endTime.equals(other.endTime) && this.sortOrder.equals(other.sortOrder) && this.cursor.equals(other.cursor) && this.locationId.equals(other.locationId) && this.total.equals(other.total) && this.last4.equals(other.last4) && this.cardBrand.equals(other.cardBrand) && this.limit.equals(other.limit) && this.isOfflinePayment.equals(other.isOfflinePayment) && this.offlineBeginTime.equals(other.offlineBeginTime) && this.offlineEndTime.equals(other.offlineEndTime) && this.updatedAtBeginTime.equals(other.updatedAtBeginTime) && this.updatedAtEndTime.equals(other.updatedAtEndTime) && this.sortField.equals(other.sortField);
    }

    public int hashCode() {
        return Objects.hash(this.beginTime, this.endTime, this.sortOrder, this.cursor, this.locationId, this.total, this.last4, this.cardBrand, this.limit, this.isOfflinePayment, this.offlineBeginTime, this.offlineEndTime, this.updatedAtBeginTime, this.updatedAtEndTime, this.sortField);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> beginTime = Optional.empty();
        private Optional<String> endTime = Optional.empty();
        private Optional<String> sortOrder = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<Long> total = Optional.empty();
        private Optional<String> last4 = Optional.empty();
        private Optional<String> cardBrand = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Boolean> isOfflinePayment = Optional.empty();
        private Optional<String> offlineBeginTime = Optional.empty();
        private Optional<String> offlineEndTime = Optional.empty();
        private Optional<String> updatedAtBeginTime = Optional.empty();
        private Optional<String> updatedAtEndTime = Optional.empty();
        private Optional<ListPaymentsRequestSortField> sortField = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListPaymentsRequest other) {
            this.beginTime(other.getBeginTime());
            this.endTime(other.getEndTime());
            this.sortOrder(other.getSortOrder());
            this.cursor(other.getCursor());
            this.locationId(other.getLocationId());
            this.total(other.getTotal());
            this.last4(other.getLast4());
            this.cardBrand(other.getCardBrand());
            this.limit(other.getLimit());
            this.isOfflinePayment(other.getIsOfflinePayment());
            this.offlineBeginTime(other.getOfflineBeginTime());
            this.offlineEndTime(other.getOfflineEndTime());
            this.updatedAtBeginTime(other.getUpdatedAtBeginTime());
            this.updatedAtEndTime(other.getUpdatedAtEndTime());
            this.sortField(other.getSortField());
            return this;
        }

        @JsonSetter(value="begin_time", nulls=Nulls.SKIP)
        public Builder beginTime(Optional<String> beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder beginTime(String beginTime) {
            this.beginTime = Optional.ofNullable(beginTime);
            return this;
        }

        public Builder beginTime(Nullable<String> beginTime) {
            this.beginTime = beginTime.isNull() ? null : (beginTime.isEmpty() ? Optional.empty() : Optional.of(beginTime.get()));
            return this;
        }

        @JsonSetter(value="end_time", nulls=Nulls.SKIP)
        public Builder endTime(Optional<String> endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = Optional.ofNullable(endTime);
            return this;
        }

        public Builder endTime(Nullable<String> endTime) {
            this.endTime = endTime.isNull() ? null : (endTime.isEmpty() ? Optional.empty() : Optional.of(endTime.get()));
            return this;
        }

        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public Builder sortOrder(Optional<String> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        public Builder sortOrder(Nullable<String> sortOrder) {
            this.sortOrder = sortOrder.isNull() ? null : (sortOrder.isEmpty() ? Optional.empty() : Optional.of(sortOrder.get()));
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="total", nulls=Nulls.SKIP)
        public Builder total(Optional<Long> total) {
            this.total = total;
            return this;
        }

        public Builder total(Long total) {
            this.total = Optional.ofNullable(total);
            return this;
        }

        public Builder total(Nullable<Long> total) {
            this.total = total.isNull() ? null : (total.isEmpty() ? Optional.empty() : Optional.of(total.get()));
            return this;
        }

        @JsonSetter(value="last_4", nulls=Nulls.SKIP)
        public Builder last4(Optional<String> last4) {
            this.last4 = last4;
            return this;
        }

        public Builder last4(String last4) {
            this.last4 = Optional.ofNullable(last4);
            return this;
        }

        public Builder last4(Nullable<String> last4) {
            this.last4 = last4.isNull() ? null : (last4.isEmpty() ? Optional.empty() : Optional.of(last4.get()));
            return this;
        }

        @JsonSetter(value="card_brand", nulls=Nulls.SKIP)
        public Builder cardBrand(Optional<String> cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        public Builder cardBrand(String cardBrand) {
            this.cardBrand = Optional.ofNullable(cardBrand);
            return this;
        }

        public Builder cardBrand(Nullable<String> cardBrand) {
            this.cardBrand = cardBrand.isNull() ? null : (cardBrand.isEmpty() ? Optional.empty() : Optional.of(cardBrand.get()));
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @JsonSetter(value="is_offline_payment", nulls=Nulls.SKIP)
        public Builder isOfflinePayment(Optional<Boolean> isOfflinePayment) {
            this.isOfflinePayment = isOfflinePayment;
            return this;
        }

        public Builder isOfflinePayment(Boolean isOfflinePayment) {
            this.isOfflinePayment = Optional.ofNullable(isOfflinePayment);
            return this;
        }

        public Builder isOfflinePayment(Nullable<Boolean> isOfflinePayment) {
            this.isOfflinePayment = isOfflinePayment.isNull() ? null : (isOfflinePayment.isEmpty() ? Optional.empty() : Optional.of(isOfflinePayment.get()));
            return this;
        }

        @JsonSetter(value="offline_begin_time", nulls=Nulls.SKIP)
        public Builder offlineBeginTime(Optional<String> offlineBeginTime) {
            this.offlineBeginTime = offlineBeginTime;
            return this;
        }

        public Builder offlineBeginTime(String offlineBeginTime) {
            this.offlineBeginTime = Optional.ofNullable(offlineBeginTime);
            return this;
        }

        public Builder offlineBeginTime(Nullable<String> offlineBeginTime) {
            this.offlineBeginTime = offlineBeginTime.isNull() ? null : (offlineBeginTime.isEmpty() ? Optional.empty() : Optional.of(offlineBeginTime.get()));
            return this;
        }

        @JsonSetter(value="offline_end_time", nulls=Nulls.SKIP)
        public Builder offlineEndTime(Optional<String> offlineEndTime) {
            this.offlineEndTime = offlineEndTime;
            return this;
        }

        public Builder offlineEndTime(String offlineEndTime) {
            this.offlineEndTime = Optional.ofNullable(offlineEndTime);
            return this;
        }

        public Builder offlineEndTime(Nullable<String> offlineEndTime) {
            this.offlineEndTime = offlineEndTime.isNull() ? null : (offlineEndTime.isEmpty() ? Optional.empty() : Optional.of(offlineEndTime.get()));
            return this;
        }

        @JsonSetter(value="updated_at_begin_time", nulls=Nulls.SKIP)
        public Builder updatedAtBeginTime(Optional<String> updatedAtBeginTime) {
            this.updatedAtBeginTime = updatedAtBeginTime;
            return this;
        }

        public Builder updatedAtBeginTime(String updatedAtBeginTime) {
            this.updatedAtBeginTime = Optional.ofNullable(updatedAtBeginTime);
            return this;
        }

        public Builder updatedAtBeginTime(Nullable<String> updatedAtBeginTime) {
            this.updatedAtBeginTime = updatedAtBeginTime.isNull() ? null : (updatedAtBeginTime.isEmpty() ? Optional.empty() : Optional.of(updatedAtBeginTime.get()));
            return this;
        }

        @JsonSetter(value="updated_at_end_time", nulls=Nulls.SKIP)
        public Builder updatedAtEndTime(Optional<String> updatedAtEndTime) {
            this.updatedAtEndTime = updatedAtEndTime;
            return this;
        }

        public Builder updatedAtEndTime(String updatedAtEndTime) {
            this.updatedAtEndTime = Optional.ofNullable(updatedAtEndTime);
            return this;
        }

        public Builder updatedAtEndTime(Nullable<String> updatedAtEndTime) {
            this.updatedAtEndTime = updatedAtEndTime.isNull() ? null : (updatedAtEndTime.isEmpty() ? Optional.empty() : Optional.of(updatedAtEndTime.get()));
            return this;
        }

        @JsonSetter(value="sort_field", nulls=Nulls.SKIP)
        public Builder sortField(Optional<ListPaymentsRequestSortField> sortField) {
            this.sortField = sortField;
            return this;
        }

        public Builder sortField(ListPaymentsRequestSortField sortField) {
            this.sortField = Optional.ofNullable(sortField);
            return this;
        }

        public Builder sortField(Nullable<ListPaymentsRequestSortField> sortField) {
            this.sortField = sortField.isNull() ? null : (sortField.isEmpty() ? Optional.empty() : Optional.of(sortField.get()));
            return this;
        }

        public ListPaymentsRequest build() {
            return new ListPaymentsRequest(this.beginTime, this.endTime, this.sortOrder, this.cursor, this.locationId, this.total, this.last4, this.cardBrand, this.limit, this.isOfflinePayment, this.offlineBeginTime, this.offlineEndTime, this.updatedAtBeginTime, this.updatedAtEndTime, this.sortField, this.additionalProperties);
        }
    }
}

