/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Payment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListPaymentsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<Payment>> payments;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private ListPaymentsResponse(Optional<List<Error>> errors, Optional<List<Payment>> payments, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.payments = payments;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="payments")
    public Optional<List<Payment>> getPayments() {
        return this.payments;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListPaymentsResponse && this.equalTo((ListPaymentsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListPaymentsResponse other) {
        return this.errors.equals(other.errors) && this.payments.equals(other.payments) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.payments, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<Payment>> payments = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListPaymentsResponse other) {
            this.errors(other.getErrors());
            this.payments(other.getPayments());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="payments", nulls=Nulls.SKIP)
        public Builder payments(Optional<List<Payment>> payments) {
            this.payments = payments;
            return this;
        }

        public Builder payments(List<Payment> payments) {
            this.payments = Optional.ofNullable(payments);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public ListPaymentsResponse build() {
            return new ListPaymentsResponse(this.errors, this.payments, this.cursor, this.additionalProperties);
        }
    }
}

