/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Site;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListSitesResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<Site>> sites;
    private final Map<String, Object> additionalProperties;

    private ListSitesResponse(Optional<List<Error>> errors, Optional<List<Site>> sites, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.sites = sites;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="sites")
    public Optional<List<Site>> getSites() {
        return this.sites;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListSitesResponse && this.equalTo((ListSitesResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListSitesResponse other) {
        return this.errors.equals(other.errors) && this.sites.equals(other.sites);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.sites);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<Site>> sites = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListSitesResponse other) {
            this.errors(other.getErrors());
            this.sites(other.getSites());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="sites", nulls=Nulls.SKIP)
        public Builder sites(Optional<List<Site>> sites) {
            this.sites = sites;
            return this;
        }

        public Builder sites(List<Site> sites) {
            this.sites = Optional.ofNullable(sites);
            return this;
        }

        public ListSitesResponse build() {
            return new ListSitesResponse(this.errors, this.sites, this.additionalProperties);
        }
    }
}

