/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class LocationCapability {
    public static final LocationCapability CREDIT_CARD_PROCESSING = new LocationCapability(Value.CREDIT_CARD_PROCESSING, "CREDIT_CARD_PROCESSING");
    public static final LocationCapability AUTOMATIC_TRANSFERS = new LocationCapability(Value.AUTOMATIC_TRANSFERS, "AUTOMATIC_TRANSFERS");
    public static final LocationCapability UNLINKED_REFUNDS = new LocationCapability(Value.UNLINKED_REFUNDS, "UNLINKED_REFUNDS");
    private final Value value;
    private final String string;

    LocationCapability(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof LocationCapability && this.string.equals(((LocationCapability)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CREDIT_CARD_PROCESSING: {
                return visitor.visitCreditCardProcessing();
            }
            case AUTOMATIC_TRANSFERS: {
                return visitor.visitAutomaticTransfers();
            }
            case UNLINKED_REFUNDS: {
                return visitor.visitUnlinkedRefunds();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static LocationCapability valueOf(String value) {
        switch (value) {
            case "CREDIT_CARD_PROCESSING": {
                return CREDIT_CARD_PROCESSING;
            }
            case "AUTOMATIC_TRANSFERS": {
                return AUTOMATIC_TRANSFERS;
            }
            case "UNLINKED_REFUNDS": {
                return UNLINKED_REFUNDS;
            }
        }
        return new LocationCapability(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitCreditCardProcessing();

        public T visitAutomaticTransfers();

        public T visitUnlinkedRefunds();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        CREDIT_CARD_PROCESSING,
        AUTOMATIC_TRANSFERS,
        UNLINKED_REFUNDS,
        UNKNOWN;

    }
}

