/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CheckoutLocationSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LocationSettingsUpdatedEventObject {
    private final Optional<CheckoutLocationSettings> locationSettings;
    private final Map<String, Object> additionalProperties;

    private LocationSettingsUpdatedEventObject(Optional<CheckoutLocationSettings> locationSettings, Map<String, Object> additionalProperties) {
        this.locationSettings = locationSettings;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_settings")
    public Optional<CheckoutLocationSettings> getLocationSettings() {
        return this.locationSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LocationSettingsUpdatedEventObject && this.equalTo((LocationSettingsUpdatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LocationSettingsUpdatedEventObject other) {
        return this.locationSettings.equals(other.locationSettings);
    }

    public int hashCode() {
        return Objects.hash(this.locationSettings);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CheckoutLocationSettings> locationSettings = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LocationSettingsUpdatedEventObject other) {
            this.locationSettings(other.getLocationSettings());
            return this;
        }

        @JsonSetter(value="location_settings", nulls=Nulls.SKIP)
        public Builder locationSettings(Optional<CheckoutLocationSettings> locationSettings) {
            this.locationSettings = locationSettings;
            return this;
        }

        public Builder locationSettings(CheckoutLocationSettings locationSettings) {
            this.locationSettings = Optional.ofNullable(locationSettings);
            return this;
        }

        public LocationSettingsUpdatedEventObject build() {
            return new LocationSettingsUpdatedEventObject(this.locationSettings, this.additionalProperties);
        }
    }
}

