/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyAccountMapping {
    private final Optional<String> id;
    private final Optional<String> createdAt;
    private final Optional<String> phoneNumber;
    private final Map<String, Object> additionalProperties;

    private LoyaltyAccountMapping(Optional<String> id, Optional<String> createdAt, Optional<String> phoneNumber, Map<String, Object> additionalProperties) {
        this.id = id;
        this.createdAt = createdAt;
        this.phoneNumber = phoneNumber;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        if (this.phoneNumber == null) {
            return Optional.empty();
        }
        return this.phoneNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number")
    private Optional<String> _getPhoneNumber() {
        return this.phoneNumber;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyAccountMapping && this.equalTo((LoyaltyAccountMapping)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyAccountMapping other) {
        return this.id.equals(other.id) && this.createdAt.equals(other.createdAt) && this.phoneNumber.equals(other.phoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.phoneNumber);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LoyaltyAccountMapping other) {
            this.id(other.getId());
            this.createdAt(other.getCreatedAt());
            this.phoneNumber(other.getPhoneNumber());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        public Builder phoneNumber(Nullable<String> phoneNumber) {
            this.phoneNumber = phoneNumber.isNull() ? null : (phoneNumber.isEmpty() ? Optional.empty() : Optional.of(phoneNumber.get()));
            return this;
        }

        public LoyaltyAccountMapping build() {
            return new LoyaltyAccountMapping(this.id, this.createdAt, this.phoneNumber, this.additionalProperties);
        }
    }
}

