/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyEventAccumulatePoints;
import com.squareup.square.types.LoyaltyEventAccumulatePromotionPoints;
import com.squareup.square.types.LoyaltyEventAdjustPoints;
import com.squareup.square.types.LoyaltyEventCreateReward;
import com.squareup.square.types.LoyaltyEventDeleteReward;
import com.squareup.square.types.LoyaltyEventExpirePoints;
import com.squareup.square.types.LoyaltyEventOther;
import com.squareup.square.types.LoyaltyEventRedeemReward;
import com.squareup.square.types.LoyaltyEventSource;
import com.squareup.square.types.LoyaltyEventType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyEvent {
    private final Optional<String> id;
    private final LoyaltyEventType type;
    private final Optional<String> createdAt;
    private final Optional<LoyaltyEventAccumulatePoints> accumulatePoints;
    private final Optional<LoyaltyEventCreateReward> createReward;
    private final Optional<LoyaltyEventRedeemReward> redeemReward;
    private final Optional<LoyaltyEventDeleteReward> deleteReward;
    private final Optional<LoyaltyEventAdjustPoints> adjustPoints;
    private final Optional<String> loyaltyAccountId;
    private final Optional<String> locationId;
    private final LoyaltyEventSource source;
    private final Optional<LoyaltyEventExpirePoints> expirePoints;
    private final Optional<LoyaltyEventOther> otherEvent;
    private final Optional<LoyaltyEventAccumulatePromotionPoints> accumulatePromotionPoints;
    private final Map<String, Object> additionalProperties;

    private LoyaltyEvent(Optional<String> id, LoyaltyEventType type, Optional<String> createdAt, Optional<LoyaltyEventAccumulatePoints> accumulatePoints, Optional<LoyaltyEventCreateReward> createReward, Optional<LoyaltyEventRedeemReward> redeemReward, Optional<LoyaltyEventDeleteReward> deleteReward, Optional<LoyaltyEventAdjustPoints> adjustPoints, Optional<String> loyaltyAccountId, Optional<String> locationId, LoyaltyEventSource source, Optional<LoyaltyEventExpirePoints> expirePoints, Optional<LoyaltyEventOther> otherEvent, Optional<LoyaltyEventAccumulatePromotionPoints> accumulatePromotionPoints, Map<String, Object> additionalProperties) {
        this.id = id;
        this.type = type;
        this.createdAt = createdAt;
        this.accumulatePoints = accumulatePoints;
        this.createReward = createReward;
        this.redeemReward = redeemReward;
        this.deleteReward = deleteReward;
        this.adjustPoints = adjustPoints;
        this.loyaltyAccountId = loyaltyAccountId;
        this.locationId = locationId;
        this.source = source;
        this.expirePoints = expirePoints;
        this.otherEvent = otherEvent;
        this.accumulatePromotionPoints = accumulatePromotionPoints;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="type")
    public LoyaltyEventType getType() {
        return this.type;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="accumulate_points")
    public Optional<LoyaltyEventAccumulatePoints> getAccumulatePoints() {
        return this.accumulatePoints;
    }

    @JsonProperty(value="create_reward")
    public Optional<LoyaltyEventCreateReward> getCreateReward() {
        return this.createReward;
    }

    @JsonProperty(value="redeem_reward")
    public Optional<LoyaltyEventRedeemReward> getRedeemReward() {
        return this.redeemReward;
    }

    @JsonProperty(value="delete_reward")
    public Optional<LoyaltyEventDeleteReward> getDeleteReward() {
        return this.deleteReward;
    }

    @JsonProperty(value="adjust_points")
    public Optional<LoyaltyEventAdjustPoints> getAdjustPoints() {
        return this.adjustPoints;
    }

    @JsonProperty(value="loyalty_account_id")
    public Optional<String> getLoyaltyAccountId() {
        return this.loyaltyAccountId;
    }

    @JsonProperty(value="location_id")
    public Optional<String> getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="source")
    public LoyaltyEventSource getSource() {
        return this.source;
    }

    @JsonProperty(value="expire_points")
    public Optional<LoyaltyEventExpirePoints> getExpirePoints() {
        return this.expirePoints;
    }

    @JsonProperty(value="other_event")
    public Optional<LoyaltyEventOther> getOtherEvent() {
        return this.otherEvent;
    }

    @JsonProperty(value="accumulate_promotion_points")
    public Optional<LoyaltyEventAccumulatePromotionPoints> getAccumulatePromotionPoints() {
        return this.accumulatePromotionPoints;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyEvent && this.equalTo((LoyaltyEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyEvent other) {
        return this.id.equals(other.id) && this.type.equals(other.type) && this.createdAt.equals(other.createdAt) && this.accumulatePoints.equals(other.accumulatePoints) && this.createReward.equals(other.createReward) && this.redeemReward.equals(other.redeemReward) && this.deleteReward.equals(other.deleteReward) && this.adjustPoints.equals(other.adjustPoints) && this.loyaltyAccountId.equals(other.loyaltyAccountId) && this.locationId.equals(other.locationId) && this.source.equals(other.source) && this.expirePoints.equals(other.expirePoints) && this.otherEvent.equals(other.otherEvent) && this.accumulatePromotionPoints.equals(other.accumulatePromotionPoints);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.createdAt, this.accumulatePoints, this.createReward, this.redeemReward, this.deleteReward, this.adjustPoints, this.loyaltyAccountId, this.locationId, this.source, this.expirePoints, this.otherEvent, this.accumulatePromotionPoints);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    SourceStage,
    _FinalStage {
        private LoyaltyEventType type;
        private LoyaltyEventSource source;
        private Optional<LoyaltyEventAccumulatePromotionPoints> accumulatePromotionPoints = Optional.empty();
        private Optional<LoyaltyEventOther> otherEvent = Optional.empty();
        private Optional<LoyaltyEventExpirePoints> expirePoints = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> loyaltyAccountId = Optional.empty();
        private Optional<LoyaltyEventAdjustPoints> adjustPoints = Optional.empty();
        private Optional<LoyaltyEventDeleteReward> deleteReward = Optional.empty();
        private Optional<LoyaltyEventRedeemReward> redeemReward = Optional.empty();
        private Optional<LoyaltyEventCreateReward> createReward = Optional.empty();
        private Optional<LoyaltyEventAccumulatePoints> accumulatePoints = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LoyaltyEvent other) {
            this.id(other.getId());
            this.type(other.getType());
            this.createdAt(other.getCreatedAt());
            this.accumulatePoints(other.getAccumulatePoints());
            this.createReward(other.getCreateReward());
            this.redeemReward(other.getRedeemReward());
            this.deleteReward(other.getDeleteReward());
            this.adjustPoints(other.getAdjustPoints());
            this.loyaltyAccountId(other.getLoyaltyAccountId());
            this.locationId(other.getLocationId());
            this.source(other.getSource());
            this.expirePoints(other.getExpirePoints());
            this.otherEvent(other.getOtherEvent());
            this.accumulatePromotionPoints(other.getAccumulatePromotionPoints());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public SourceStage type(@NotNull LoyaltyEventType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="source")
        public _FinalStage source(@NotNull LoyaltyEventSource source) {
            this.source = Objects.requireNonNull(source, "source must not be null");
            return this;
        }

        @Override
        public _FinalStage accumulatePromotionPoints(LoyaltyEventAccumulatePromotionPoints accumulatePromotionPoints) {
            this.accumulatePromotionPoints = Optional.ofNullable(accumulatePromotionPoints);
            return this;
        }

        @Override
        @JsonSetter(value="accumulate_promotion_points", nulls=Nulls.SKIP)
        public _FinalStage accumulatePromotionPoints(Optional<LoyaltyEventAccumulatePromotionPoints> accumulatePromotionPoints) {
            this.accumulatePromotionPoints = accumulatePromotionPoints;
            return this;
        }

        @Override
        public _FinalStage otherEvent(LoyaltyEventOther otherEvent) {
            this.otherEvent = Optional.ofNullable(otherEvent);
            return this;
        }

        @Override
        @JsonSetter(value="other_event", nulls=Nulls.SKIP)
        public _FinalStage otherEvent(Optional<LoyaltyEventOther> otherEvent) {
            this.otherEvent = otherEvent;
            return this;
        }

        @Override
        public _FinalStage expirePoints(LoyaltyEventExpirePoints expirePoints) {
            this.expirePoints = Optional.ofNullable(expirePoints);
            return this;
        }

        @Override
        @JsonSetter(value="expire_points", nulls=Nulls.SKIP)
        public _FinalStage expirePoints(Optional<LoyaltyEventExpirePoints> expirePoints) {
            this.expirePoints = expirePoints;
            return this;
        }

        @Override
        public _FinalStage locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @Override
        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public _FinalStage locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        @Override
        public _FinalStage loyaltyAccountId(String loyaltyAccountId) {
            this.loyaltyAccountId = Optional.ofNullable(loyaltyAccountId);
            return this;
        }

        @Override
        @JsonSetter(value="loyalty_account_id", nulls=Nulls.SKIP)
        public _FinalStage loyaltyAccountId(Optional<String> loyaltyAccountId) {
            this.loyaltyAccountId = loyaltyAccountId;
            return this;
        }

        @Override
        public _FinalStage adjustPoints(LoyaltyEventAdjustPoints adjustPoints) {
            this.adjustPoints = Optional.ofNullable(adjustPoints);
            return this;
        }

        @Override
        @JsonSetter(value="adjust_points", nulls=Nulls.SKIP)
        public _FinalStage adjustPoints(Optional<LoyaltyEventAdjustPoints> adjustPoints) {
            this.adjustPoints = adjustPoints;
            return this;
        }

        @Override
        public _FinalStage deleteReward(LoyaltyEventDeleteReward deleteReward) {
            this.deleteReward = Optional.ofNullable(deleteReward);
            return this;
        }

        @Override
        @JsonSetter(value="delete_reward", nulls=Nulls.SKIP)
        public _FinalStage deleteReward(Optional<LoyaltyEventDeleteReward> deleteReward) {
            this.deleteReward = deleteReward;
            return this;
        }

        @Override
        public _FinalStage redeemReward(LoyaltyEventRedeemReward redeemReward) {
            this.redeemReward = Optional.ofNullable(redeemReward);
            return this;
        }

        @Override
        @JsonSetter(value="redeem_reward", nulls=Nulls.SKIP)
        public _FinalStage redeemReward(Optional<LoyaltyEventRedeemReward> redeemReward) {
            this.redeemReward = redeemReward;
            return this;
        }

        @Override
        public _FinalStage createReward(LoyaltyEventCreateReward createReward) {
            this.createReward = Optional.ofNullable(createReward);
            return this;
        }

        @Override
        @JsonSetter(value="create_reward", nulls=Nulls.SKIP)
        public _FinalStage createReward(Optional<LoyaltyEventCreateReward> createReward) {
            this.createReward = createReward;
            return this;
        }

        @Override
        public _FinalStage accumulatePoints(LoyaltyEventAccumulatePoints accumulatePoints) {
            this.accumulatePoints = Optional.ofNullable(accumulatePoints);
            return this;
        }

        @Override
        @JsonSetter(value="accumulate_points", nulls=Nulls.SKIP)
        public _FinalStage accumulatePoints(Optional<LoyaltyEventAccumulatePoints> accumulatePoints) {
            this.accumulatePoints = accumulatePoints;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public LoyaltyEvent build() {
            return new LoyaltyEvent(this.id, this.type, this.createdAt, this.accumulatePoints, this.createReward, this.redeemReward, this.deleteReward, this.adjustPoints, this.loyaltyAccountId, this.locationId, this.source, this.expirePoints, this.otherEvent, this.accumulatePromotionPoints, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LoyaltyEvent build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage accumulatePoints(Optional<LoyaltyEventAccumulatePoints> var1);

        public _FinalStage accumulatePoints(LoyaltyEventAccumulatePoints var1);

        public _FinalStage createReward(Optional<LoyaltyEventCreateReward> var1);

        public _FinalStage createReward(LoyaltyEventCreateReward var1);

        public _FinalStage redeemReward(Optional<LoyaltyEventRedeemReward> var1);

        public _FinalStage redeemReward(LoyaltyEventRedeemReward var1);

        public _FinalStage deleteReward(Optional<LoyaltyEventDeleteReward> var1);

        public _FinalStage deleteReward(LoyaltyEventDeleteReward var1);

        public _FinalStage adjustPoints(Optional<LoyaltyEventAdjustPoints> var1);

        public _FinalStage adjustPoints(LoyaltyEventAdjustPoints var1);

        public _FinalStage loyaltyAccountId(Optional<String> var1);

        public _FinalStage loyaltyAccountId(String var1);

        public _FinalStage locationId(Optional<String> var1);

        public _FinalStage locationId(String var1);

        public _FinalStage expirePoints(Optional<LoyaltyEventExpirePoints> var1);

        public _FinalStage expirePoints(LoyaltyEventExpirePoints var1);

        public _FinalStage otherEvent(Optional<LoyaltyEventOther> var1);

        public _FinalStage otherEvent(LoyaltyEventOther var1);

        public _FinalStage accumulatePromotionPoints(Optional<LoyaltyEventAccumulatePromotionPoints> var1);

        public _FinalStage accumulatePromotionPoints(LoyaltyEventAccumulatePromotionPoints var1);
    }

    public static interface SourceStage {
        public _FinalStage source(@NotNull LoyaltyEventSource var1);
    }

    public static interface TypeStage {
        public SourceStage type(@NotNull LoyaltyEventType var1);

        public Builder from(LoyaltyEvent var1);
    }
}

