/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyProgramAccrualRuleTaxMode;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyProgramAccrualRuleVisitData {
    private final Optional<Money> minimumAmountMoney;
    private final LoyaltyProgramAccrualRuleTaxMode taxMode;
    private final Map<String, Object> additionalProperties;

    private LoyaltyProgramAccrualRuleVisitData(Optional<Money> minimumAmountMoney, LoyaltyProgramAccrualRuleTaxMode taxMode, Map<String, Object> additionalProperties) {
        this.minimumAmountMoney = minimumAmountMoney;
        this.taxMode = taxMode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="minimum_amount_money")
    public Optional<Money> getMinimumAmountMoney() {
        return this.minimumAmountMoney;
    }

    @JsonProperty(value="tax_mode")
    public LoyaltyProgramAccrualRuleTaxMode getTaxMode() {
        return this.taxMode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyProgramAccrualRuleVisitData && this.equalTo((LoyaltyProgramAccrualRuleVisitData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyProgramAccrualRuleVisitData other) {
        return this.minimumAmountMoney.equals(other.minimumAmountMoney) && this.taxMode.equals(other.taxMode);
    }

    public int hashCode() {
        return Objects.hash(this.minimumAmountMoney, this.taxMode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaxModeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TaxModeStage,
    _FinalStage {
        private LoyaltyProgramAccrualRuleTaxMode taxMode;
        private Optional<Money> minimumAmountMoney = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LoyaltyProgramAccrualRuleVisitData other) {
            this.minimumAmountMoney(other.getMinimumAmountMoney());
            this.taxMode(other.getTaxMode());
            return this;
        }

        @Override
        @JsonSetter(value="tax_mode")
        public _FinalStage taxMode(@NotNull LoyaltyProgramAccrualRuleTaxMode taxMode) {
            this.taxMode = Objects.requireNonNull(taxMode, "taxMode must not be null");
            return this;
        }

        @Override
        public _FinalStage minimumAmountMoney(Money minimumAmountMoney) {
            this.minimumAmountMoney = Optional.ofNullable(minimumAmountMoney);
            return this;
        }

        @Override
        @JsonSetter(value="minimum_amount_money", nulls=Nulls.SKIP)
        public _FinalStage minimumAmountMoney(Optional<Money> minimumAmountMoney) {
            this.minimumAmountMoney = minimumAmountMoney;
            return this;
        }

        @Override
        public LoyaltyProgramAccrualRuleVisitData build() {
            return new LoyaltyProgramAccrualRuleVisitData(this.minimumAmountMoney, this.taxMode, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LoyaltyProgramAccrualRuleVisitData build();

        public _FinalStage minimumAmountMoney(Optional<Money> var1);

        public _FinalStage minimumAmountMoney(Money var1);
    }

    public static interface TaxModeStage {
        public _FinalStage taxMode(@NotNull LoyaltyProgramAccrualRuleTaxMode var1);

        public Builder from(LoyaltyProgramAccrualRuleVisitData var1);
    }
}

