/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyPromotionAvailableTimeData {
    private final Optional<String> startDate;
    private final Optional<String> endDate;
    private final List<String> timePeriods;
    private final Map<String, Object> additionalProperties;

    private LoyaltyPromotionAvailableTimeData(Optional<String> startDate, Optional<String> endDate, List<String> timePeriods, Map<String, Object> additionalProperties) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.timePeriods = timePeriods;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="start_date")
    public Optional<String> getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="end_date")
    public Optional<String> getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="time_periods")
    public List<String> getTimePeriods() {
        return this.timePeriods;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyPromotionAvailableTimeData && this.equalTo((LoyaltyPromotionAvailableTimeData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyPromotionAvailableTimeData other) {
        return this.startDate.equals(other.startDate) && this.endDate.equals(other.endDate) && this.timePeriods.equals(other.timePeriods);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.timePeriods);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> startDate = Optional.empty();
        private Optional<String> endDate = Optional.empty();
        private List<String> timePeriods = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LoyaltyPromotionAvailableTimeData other) {
            this.startDate(other.getStartDate());
            this.endDate(other.getEndDate());
            this.timePeriods(other.getTimePeriods());
            return this;
        }

        @JsonSetter(value="start_date", nulls=Nulls.SKIP)
        public Builder startDate(Optional<String> startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder startDate(String startDate) {
            this.startDate = Optional.ofNullable(startDate);
            return this;
        }

        @JsonSetter(value="end_date", nulls=Nulls.SKIP)
        public Builder endDate(Optional<String> endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder endDate(String endDate) {
            this.endDate = Optional.ofNullable(endDate);
            return this;
        }

        @JsonSetter(value="time_periods", nulls=Nulls.SKIP)
        public Builder timePeriods(List<String> timePeriods) {
            this.timePeriods.clear();
            this.timePeriods.addAll(timePeriods);
            return this;
        }

        public Builder addTimePeriods(String timePeriods) {
            this.timePeriods.add(timePeriods);
            return this;
        }

        public Builder addAllTimePeriods(List<String> timePeriods) {
            this.timePeriods.addAll(timePeriods);
            return this;
        }

        public LoyaltyPromotionAvailableTimeData build() {
            return new LoyaltyPromotionAvailableTimeData(this.startDate, this.endDate, this.timePeriods, this.additionalProperties);
        }
    }
}

