/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyPromotionIncentivePointsAdditionData;
import com.squareup.square.types.LoyaltyPromotionIncentivePointsMultiplierData;
import com.squareup.square.types.LoyaltyPromotionIncentiveType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyPromotionIncentive {
    private final LoyaltyPromotionIncentiveType type;
    private final Optional<LoyaltyPromotionIncentivePointsMultiplierData> pointsMultiplierData;
    private final Optional<LoyaltyPromotionIncentivePointsAdditionData> pointsAdditionData;
    private final Map<String, Object> additionalProperties;

    private LoyaltyPromotionIncentive(LoyaltyPromotionIncentiveType type, Optional<LoyaltyPromotionIncentivePointsMultiplierData> pointsMultiplierData, Optional<LoyaltyPromotionIncentivePointsAdditionData> pointsAdditionData, Map<String, Object> additionalProperties) {
        this.type = type;
        this.pointsMultiplierData = pointsMultiplierData;
        this.pointsAdditionData = pointsAdditionData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public LoyaltyPromotionIncentiveType getType() {
        return this.type;
    }

    @JsonProperty(value="points_multiplier_data")
    public Optional<LoyaltyPromotionIncentivePointsMultiplierData> getPointsMultiplierData() {
        return this.pointsMultiplierData;
    }

    @JsonProperty(value="points_addition_data")
    public Optional<LoyaltyPromotionIncentivePointsAdditionData> getPointsAdditionData() {
        return this.pointsAdditionData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyPromotionIncentive && this.equalTo((LoyaltyPromotionIncentive)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyPromotionIncentive other) {
        return this.type.equals(other.type) && this.pointsMultiplierData.equals(other.pointsMultiplierData) && this.pointsAdditionData.equals(other.pointsAdditionData);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.pointsMultiplierData, this.pointsAdditionData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    _FinalStage {
        private LoyaltyPromotionIncentiveType type;
        private Optional<LoyaltyPromotionIncentivePointsAdditionData> pointsAdditionData = Optional.empty();
        private Optional<LoyaltyPromotionIncentivePointsMultiplierData> pointsMultiplierData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LoyaltyPromotionIncentive other) {
            this.type(other.getType());
            this.pointsMultiplierData(other.getPointsMultiplierData());
            this.pointsAdditionData(other.getPointsAdditionData());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull LoyaltyPromotionIncentiveType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage pointsAdditionData(LoyaltyPromotionIncentivePointsAdditionData pointsAdditionData) {
            this.pointsAdditionData = Optional.ofNullable(pointsAdditionData);
            return this;
        }

        @Override
        @JsonSetter(value="points_addition_data", nulls=Nulls.SKIP)
        public _FinalStage pointsAdditionData(Optional<LoyaltyPromotionIncentivePointsAdditionData> pointsAdditionData) {
            this.pointsAdditionData = pointsAdditionData;
            return this;
        }

        @Override
        public _FinalStage pointsMultiplierData(LoyaltyPromotionIncentivePointsMultiplierData pointsMultiplierData) {
            this.pointsMultiplierData = Optional.ofNullable(pointsMultiplierData);
            return this;
        }

        @Override
        @JsonSetter(value="points_multiplier_data", nulls=Nulls.SKIP)
        public _FinalStage pointsMultiplierData(Optional<LoyaltyPromotionIncentivePointsMultiplierData> pointsMultiplierData) {
            this.pointsMultiplierData = pointsMultiplierData;
            return this;
        }

        @Override
        public LoyaltyPromotionIncentive build() {
            return new LoyaltyPromotionIncentive(this.type, this.pointsMultiplierData, this.pointsAdditionData, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LoyaltyPromotionIncentive build();

        public _FinalStage pointsMultiplierData(Optional<LoyaltyPromotionIncentivePointsMultiplierData> var1);

        public _FinalStage pointsMultiplierData(LoyaltyPromotionIncentivePointsMultiplierData var1);

        public _FinalStage pointsAdditionData(Optional<LoyaltyPromotionIncentivePointsAdditionData> var1);

        public _FinalStage pointsAdditionData(LoyaltyPromotionIncentivePointsAdditionData var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull LoyaltyPromotionIncentiveType var1);

        public Builder from(LoyaltyPromotionIncentive var1);
    }
}

