/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyRewardStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyReward {
    private final Optional<String> id;
    private final Optional<LoyaltyRewardStatus> status;
    private final String loyaltyAccountId;
    private final String rewardTierId;
    private final Optional<Integer> points;
    private final Optional<String> orderId;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> redeemedAt;
    private final Map<String, Object> additionalProperties;

    private LoyaltyReward(Optional<String> id, Optional<LoyaltyRewardStatus> status, String loyaltyAccountId, String rewardTierId, Optional<Integer> points, Optional<String> orderId, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> redeemedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.status = status;
        this.loyaltyAccountId = loyaltyAccountId;
        this.rewardTierId = rewardTierId;
        this.points = points;
        this.orderId = orderId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.redeemedAt = redeemedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="status")
    public Optional<LoyaltyRewardStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="loyalty_account_id")
    public String getLoyaltyAccountId() {
        return this.loyaltyAccountId;
    }

    @JsonProperty(value="reward_tier_id")
    public String getRewardTierId() {
        return this.rewardTierId;
    }

    @JsonProperty(value="points")
    public Optional<Integer> getPoints() {
        return this.points;
    }

    @JsonIgnore
    public Optional<String> getOrderId() {
        if (this.orderId == null) {
            return Optional.empty();
        }
        return this.orderId;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="redeemed_at")
    public Optional<String> getRedeemedAt() {
        return this.redeemedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_id")
    private Optional<String> _getOrderId() {
        return this.orderId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyReward && this.equalTo((LoyaltyReward)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyReward other) {
        return this.id.equals(other.id) && this.status.equals(other.status) && this.loyaltyAccountId.equals(other.loyaltyAccountId) && this.rewardTierId.equals(other.rewardTierId) && this.points.equals(other.points) && this.orderId.equals(other.orderId) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.redeemedAt.equals(other.redeemedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.loyaltyAccountId, this.rewardTierId, this.points, this.orderId, this.createdAt, this.updatedAt, this.redeemedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LoyaltyAccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LoyaltyAccountIdStage,
    RewardTierIdStage,
    _FinalStage {
        private String loyaltyAccountId;
        private String rewardTierId;
        private Optional<String> redeemedAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        private Optional<Integer> points = Optional.empty();
        private Optional<LoyaltyRewardStatus> status = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LoyaltyReward other) {
            this.id(other.getId());
            this.status(other.getStatus());
            this.loyaltyAccountId(other.getLoyaltyAccountId());
            this.rewardTierId(other.getRewardTierId());
            this.points(other.getPoints());
            this.orderId(other.getOrderId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.redeemedAt(other.getRedeemedAt());
            return this;
        }

        @Override
        @JsonSetter(value="loyalty_account_id")
        public RewardTierIdStage loyaltyAccountId(@NotNull String loyaltyAccountId) {
            this.loyaltyAccountId = Objects.requireNonNull(loyaltyAccountId, "loyaltyAccountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reward_tier_id")
        public _FinalStage rewardTierId(@NotNull String rewardTierId) {
            this.rewardTierId = Objects.requireNonNull(rewardTierId, "rewardTierId must not be null");
            return this;
        }

        @Override
        public _FinalStage redeemedAt(String redeemedAt) {
            this.redeemedAt = Optional.ofNullable(redeemedAt);
            return this;
        }

        @Override
        @JsonSetter(value="redeemed_at", nulls=Nulls.SKIP)
        public _FinalStage redeemedAt(Optional<String> redeemedAt) {
            this.redeemedAt = redeemedAt;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage orderId(Nullable<String> orderId) {
            this.orderId = orderId.isNull() ? null : (orderId.isEmpty() ? Optional.empty() : Optional.of(orderId.get()));
            return this;
        }

        @Override
        public _FinalStage orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        @Override
        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public _FinalStage orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        @Override
        public _FinalStage points(Integer points) {
            this.points = Optional.ofNullable(points);
            return this;
        }

        @Override
        @JsonSetter(value="points", nulls=Nulls.SKIP)
        public _FinalStage points(Optional<Integer> points) {
            this.points = points;
            return this;
        }

        @Override
        public _FinalStage status(LoyaltyRewardStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<LoyaltyRewardStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public LoyaltyReward build() {
            return new LoyaltyReward(this.id, this.status, this.loyaltyAccountId, this.rewardTierId, this.points, this.orderId, this.createdAt, this.updatedAt, this.redeemedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LoyaltyReward build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage status(Optional<LoyaltyRewardStatus> var1);

        public _FinalStage status(LoyaltyRewardStatus var1);

        public _FinalStage points(Optional<Integer> var1);

        public _FinalStage points(Integer var1);

        public _FinalStage orderId(Optional<String> var1);

        public _FinalStage orderId(String var1);

        public _FinalStage orderId(Nullable<String> var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage redeemedAt(Optional<String> var1);

        public _FinalStage redeemedAt(String var1);
    }

    public static interface RewardTierIdStage {
        public _FinalStage rewardTierId(@NotNull String var1);
    }

    public static interface LoyaltyAccountIdStage {
        public RewardTierIdStage loyaltyAccountId(@NotNull String var1);

        public Builder from(LoyaltyReward var1);
    }
}

