/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class LoyaltyRewardStatus {
    public static final LoyaltyRewardStatus DELETED = new LoyaltyRewardStatus(Value.DELETED, "DELETED");
    public static final LoyaltyRewardStatus ISSUED = new LoyaltyRewardStatus(Value.ISSUED, "ISSUED");
    public static final LoyaltyRewardStatus REDEEMED = new LoyaltyRewardStatus(Value.REDEEMED, "REDEEMED");
    private final Value value;
    private final String string;

    LoyaltyRewardStatus(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof LoyaltyRewardStatus && this.string.equals(((LoyaltyRewardStatus)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case DELETED: {
                return visitor.visitDeleted();
            }
            case ISSUED: {
                return visitor.visitIssued();
            }
            case REDEEMED: {
                return visitor.visitRedeemed();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static LoyaltyRewardStatus valueOf(String value) {
        switch (value) {
            case "DELETED": {
                return DELETED;
            }
            case "ISSUED": {
                return ISSUED;
            }
            case "REDEEMED": {
                return REDEEMED;
            }
        }
        return new LoyaltyRewardStatus(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitIssued();

        public T visitRedeemed();

        public T visitDeleted();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        ISSUED,
        REDEEMED,
        DELETED,
        UNKNOWN;

    }
}

