/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.MeasurementUnitArea;
import com.squareup.square.types.MeasurementUnitCustom;
import com.squareup.square.types.MeasurementUnitLength;
import com.squareup.square.types.MeasurementUnitTime;
import com.squareup.square.types.MeasurementUnitUnitType;
import com.squareup.square.types.MeasurementUnitVolume;
import com.squareup.square.types.MeasurementUnitWeight;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MeasurementUnit {
    private final Optional<MeasurementUnitCustom> customUnit;
    private final Optional<MeasurementUnitArea> areaUnit;
    private final Optional<MeasurementUnitLength> lengthUnit;
    private final Optional<MeasurementUnitVolume> volumeUnit;
    private final Optional<MeasurementUnitWeight> weightUnit;
    private final Optional<String> genericUnit;
    private final Optional<MeasurementUnitTime> timeUnit;
    private final Optional<MeasurementUnitUnitType> type;
    private final Map<String, Object> additionalProperties;

    private MeasurementUnit(Optional<MeasurementUnitCustom> customUnit, Optional<MeasurementUnitArea> areaUnit, Optional<MeasurementUnitLength> lengthUnit, Optional<MeasurementUnitVolume> volumeUnit, Optional<MeasurementUnitWeight> weightUnit, Optional<String> genericUnit, Optional<MeasurementUnitTime> timeUnit, Optional<MeasurementUnitUnitType> type, Map<String, Object> additionalProperties) {
        this.customUnit = customUnit;
        this.areaUnit = areaUnit;
        this.lengthUnit = lengthUnit;
        this.volumeUnit = volumeUnit;
        this.weightUnit = weightUnit;
        this.genericUnit = genericUnit;
        this.timeUnit = timeUnit;
        this.type = type;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="custom_unit")
    public Optional<MeasurementUnitCustom> getCustomUnit() {
        return this.customUnit;
    }

    @JsonProperty(value="area_unit")
    public Optional<MeasurementUnitArea> getAreaUnit() {
        return this.areaUnit;
    }

    @JsonProperty(value="length_unit")
    public Optional<MeasurementUnitLength> getLengthUnit() {
        return this.lengthUnit;
    }

    @JsonProperty(value="volume_unit")
    public Optional<MeasurementUnitVolume> getVolumeUnit() {
        return this.volumeUnit;
    }

    @JsonProperty(value="weight_unit")
    public Optional<MeasurementUnitWeight> getWeightUnit() {
        return this.weightUnit;
    }

    @JsonProperty(value="generic_unit")
    public Optional<String> getGenericUnit() {
        return this.genericUnit;
    }

    @JsonProperty(value="time_unit")
    public Optional<MeasurementUnitTime> getTimeUnit() {
        return this.timeUnit;
    }

    @JsonProperty(value="type")
    public Optional<MeasurementUnitUnitType> getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MeasurementUnit && this.equalTo((MeasurementUnit)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MeasurementUnit other) {
        return this.customUnit.equals(other.customUnit) && this.areaUnit.equals(other.areaUnit) && this.lengthUnit.equals(other.lengthUnit) && this.volumeUnit.equals(other.volumeUnit) && this.weightUnit.equals(other.weightUnit) && this.genericUnit.equals(other.genericUnit) && this.timeUnit.equals(other.timeUnit) && this.type.equals(other.type);
    }

    public int hashCode() {
        return Objects.hash(this.customUnit, this.areaUnit, this.lengthUnit, this.volumeUnit, this.weightUnit, this.genericUnit, this.timeUnit, this.type);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<MeasurementUnitCustom> customUnit = Optional.empty();
        private Optional<MeasurementUnitArea> areaUnit = Optional.empty();
        private Optional<MeasurementUnitLength> lengthUnit = Optional.empty();
        private Optional<MeasurementUnitVolume> volumeUnit = Optional.empty();
        private Optional<MeasurementUnitWeight> weightUnit = Optional.empty();
        private Optional<String> genericUnit = Optional.empty();
        private Optional<MeasurementUnitTime> timeUnit = Optional.empty();
        private Optional<MeasurementUnitUnitType> type = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(MeasurementUnit other) {
            this.customUnit(other.getCustomUnit());
            this.areaUnit(other.getAreaUnit());
            this.lengthUnit(other.getLengthUnit());
            this.volumeUnit(other.getVolumeUnit());
            this.weightUnit(other.getWeightUnit());
            this.genericUnit(other.getGenericUnit());
            this.timeUnit(other.getTimeUnit());
            this.type(other.getType());
            return this;
        }

        @JsonSetter(value="custom_unit", nulls=Nulls.SKIP)
        public Builder customUnit(Optional<MeasurementUnitCustom> customUnit) {
            this.customUnit = customUnit;
            return this;
        }

        public Builder customUnit(MeasurementUnitCustom customUnit) {
            this.customUnit = Optional.ofNullable(customUnit);
            return this;
        }

        @JsonSetter(value="area_unit", nulls=Nulls.SKIP)
        public Builder areaUnit(Optional<MeasurementUnitArea> areaUnit) {
            this.areaUnit = areaUnit;
            return this;
        }

        public Builder areaUnit(MeasurementUnitArea areaUnit) {
            this.areaUnit = Optional.ofNullable(areaUnit);
            return this;
        }

        @JsonSetter(value="length_unit", nulls=Nulls.SKIP)
        public Builder lengthUnit(Optional<MeasurementUnitLength> lengthUnit) {
            this.lengthUnit = lengthUnit;
            return this;
        }

        public Builder lengthUnit(MeasurementUnitLength lengthUnit) {
            this.lengthUnit = Optional.ofNullable(lengthUnit);
            return this;
        }

        @JsonSetter(value="volume_unit", nulls=Nulls.SKIP)
        public Builder volumeUnit(Optional<MeasurementUnitVolume> volumeUnit) {
            this.volumeUnit = volumeUnit;
            return this;
        }

        public Builder volumeUnit(MeasurementUnitVolume volumeUnit) {
            this.volumeUnit = Optional.ofNullable(volumeUnit);
            return this;
        }

        @JsonSetter(value="weight_unit", nulls=Nulls.SKIP)
        public Builder weightUnit(Optional<MeasurementUnitWeight> weightUnit) {
            this.weightUnit = weightUnit;
            return this;
        }

        public Builder weightUnit(MeasurementUnitWeight weightUnit) {
            this.weightUnit = Optional.ofNullable(weightUnit);
            return this;
        }

        @JsonSetter(value="generic_unit", nulls=Nulls.SKIP)
        public Builder genericUnit(Optional<String> genericUnit) {
            this.genericUnit = genericUnit;
            return this;
        }

        public Builder genericUnit(String genericUnit) {
            this.genericUnit = Optional.ofNullable(genericUnit);
            return this;
        }

        @JsonSetter(value="time_unit", nulls=Nulls.SKIP)
        public Builder timeUnit(Optional<MeasurementUnitTime> timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder timeUnit(MeasurementUnitTime timeUnit) {
            this.timeUnit = Optional.ofNullable(timeUnit);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<MeasurementUnitUnitType> type) {
            this.type = type;
            return this;
        }

        public Builder type(MeasurementUnitUnitType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        public MeasurementUnit build() {
            return new MeasurementUnit(this.customUnit, this.areaUnit, this.lengthUnit, this.volumeUnit, this.weightUnit, this.genericUnit, this.timeUnit, this.type, this.additionalProperties);
        }
    }
}

