/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Country;
import com.squareup.square.types.Currency;
import com.squareup.square.types.MerchantStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Merchant {
    private final Optional<String> id;
    private final Optional<String> businessName;
    private final Country country;
    private final Optional<String> languageCode;
    private final Optional<Currency> currency;
    private final Optional<MerchantStatus> status;
    private final Optional<String> mainLocationId;
    private final Optional<String> createdAt;
    private final Map<String, Object> additionalProperties;

    private Merchant(Optional<String> id, Optional<String> businessName, Country country, Optional<String> languageCode, Optional<Currency> currency, Optional<MerchantStatus> status, Optional<String> mainLocationId, Optional<String> createdAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.businessName = businessName;
        this.country = country;
        this.languageCode = languageCode;
        this.currency = currency;
        this.status = status;
        this.mainLocationId = mainLocationId;
        this.createdAt = createdAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getBusinessName() {
        if (this.businessName == null) {
            return Optional.empty();
        }
        return this.businessName;
    }

    @JsonProperty(value="country")
    public Country getCountry() {
        return this.country;
    }

    @JsonIgnore
    public Optional<String> getLanguageCode() {
        if (this.languageCode == null) {
            return Optional.empty();
        }
        return this.languageCode;
    }

    @JsonProperty(value="currency")
    public Optional<Currency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="status")
    public Optional<MerchantStatus> getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Optional<String> getMainLocationId() {
        if (this.mainLocationId == null) {
            return Optional.empty();
        }
        return this.mainLocationId;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="business_name")
    private Optional<String> _getBusinessName() {
        return this.businessName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="language_code")
    private Optional<String> _getLanguageCode() {
        return this.languageCode;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="main_location_id")
    private Optional<String> _getMainLocationId() {
        return this.mainLocationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Merchant && this.equalTo((Merchant)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Merchant other) {
        return this.id.equals(other.id) && this.businessName.equals(other.businessName) && this.country.equals(other.country) && this.languageCode.equals(other.languageCode) && this.currency.equals(other.currency) && this.status.equals(other.status) && this.mainLocationId.equals(other.mainLocationId) && this.createdAt.equals(other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.businessName, this.country, this.languageCode, this.currency, this.status, this.mainLocationId, this.createdAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CountryStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CountryStage,
    _FinalStage {
        private Country country;
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> mainLocationId = Optional.empty();
        private Optional<MerchantStatus> status = Optional.empty();
        private Optional<Currency> currency = Optional.empty();
        private Optional<String> languageCode = Optional.empty();
        private Optional<String> businessName = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Merchant other) {
            this.id(other.getId());
            this.businessName(other.getBusinessName());
            this.country(other.getCountry());
            this.languageCode(other.getLanguageCode());
            this.currency(other.getCurrency());
            this.status(other.getStatus());
            this.mainLocationId(other.getMainLocationId());
            this.createdAt(other.getCreatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="country")
        public _FinalStage country(@NotNull Country country) {
            this.country = Objects.requireNonNull(country, "country must not be null");
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage mainLocationId(Nullable<String> mainLocationId) {
            this.mainLocationId = mainLocationId.isNull() ? null : (mainLocationId.isEmpty() ? Optional.empty() : Optional.of(mainLocationId.get()));
            return this;
        }

        @Override
        public _FinalStage mainLocationId(String mainLocationId) {
            this.mainLocationId = Optional.ofNullable(mainLocationId);
            return this;
        }

        @Override
        @JsonSetter(value="main_location_id", nulls=Nulls.SKIP)
        public _FinalStage mainLocationId(Optional<String> mainLocationId) {
            this.mainLocationId = mainLocationId;
            return this;
        }

        @Override
        public _FinalStage status(MerchantStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<MerchantStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage currency(Currency currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        @Override
        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public _FinalStage currency(Optional<Currency> currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public _FinalStage languageCode(Nullable<String> languageCode) {
            this.languageCode = languageCode.isNull() ? null : (languageCode.isEmpty() ? Optional.empty() : Optional.of(languageCode.get()));
            return this;
        }

        @Override
        public _FinalStage languageCode(String languageCode) {
            this.languageCode = Optional.ofNullable(languageCode);
            return this;
        }

        @Override
        @JsonSetter(value="language_code", nulls=Nulls.SKIP)
        public _FinalStage languageCode(Optional<String> languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public _FinalStage businessName(Nullable<String> businessName) {
            this.businessName = businessName.isNull() ? null : (businessName.isEmpty() ? Optional.empty() : Optional.of(businessName.get()));
            return this;
        }

        @Override
        public _FinalStage businessName(String businessName) {
            this.businessName = Optional.ofNullable(businessName);
            return this;
        }

        @Override
        @JsonSetter(value="business_name", nulls=Nulls.SKIP)
        public _FinalStage businessName(Optional<String> businessName) {
            this.businessName = businessName;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public Merchant build() {
            return new Merchant(this.id, this.businessName, this.country, this.languageCode, this.currency, this.status, this.mainLocationId, this.createdAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Merchant build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage businessName(Optional<String> var1);

        public _FinalStage businessName(String var1);

        public _FinalStage businessName(Nullable<String> var1);

        public _FinalStage languageCode(Optional<String> var1);

        public _FinalStage languageCode(String var1);

        public _FinalStage languageCode(Nullable<String> var1);

        public _FinalStage currency(Optional<Currency> var1);

        public _FinalStage currency(Currency var1);

        public _FinalStage status(Optional<MerchantStatus> var1);

        public _FinalStage status(MerchantStatus var1);

        public _FinalStage mainLocationId(Optional<String> var1);

        public _FinalStage mainLocationId(String var1);

        public _FinalStage mainLocationId(Nullable<String> var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);
    }

    public static interface CountryStage {
        public _FinalStage country(@NotNull Country var1);

        public Builder from(Merchant var1);
    }
}

