/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ModifierLocationOverrides {
    private final Optional<String> locationId;
    private final Optional<Money> priceMoney;
    private final Optional<Boolean> soldOut;
    private final Map<String, Object> additionalProperties;

    private ModifierLocationOverrides(Optional<String> locationId, Optional<Money> priceMoney, Optional<Boolean> soldOut, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.priceMoney = priceMoney;
        this.soldOut = soldOut;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonProperty(value="price_money")
    public Optional<Money> getPriceMoney() {
        return this.priceMoney;
    }

    @JsonProperty(value="sold_out")
    public Optional<Boolean> getSoldOut() {
        return this.soldOut;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ModifierLocationOverrides && this.equalTo((ModifierLocationOverrides)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ModifierLocationOverrides other) {
        return this.locationId.equals(other.locationId) && this.priceMoney.equals(other.priceMoney) && this.soldOut.equals(other.soldOut);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.priceMoney, this.soldOut);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> locationId = Optional.empty();
        private Optional<Money> priceMoney = Optional.empty();
        private Optional<Boolean> soldOut = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ModifierLocationOverrides other) {
            this.locationId(other.getLocationId());
            this.priceMoney(other.getPriceMoney());
            this.soldOut(other.getSoldOut());
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="price_money", nulls=Nulls.SKIP)
        public Builder priceMoney(Optional<Money> priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = Optional.ofNullable(priceMoney);
            return this;
        }

        @JsonSetter(value="sold_out", nulls=Nulls.SKIP)
        public Builder soldOut(Optional<Boolean> soldOut) {
            this.soldOut = soldOut;
            return this;
        }

        public Builder soldOut(Boolean soldOut) {
            this.soldOut = Optional.ofNullable(soldOut);
            return this;
        }

        public ModifierLocationOverrides build() {
            return new ModifierLocationOverrides(this.locationId, this.priceMoney, this.soldOut, this.additionalProperties);
        }
    }
}

