/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Money {
    private final Optional<Long> amount;
    private final Optional<Currency> currency;
    private final Map<String, Object> additionalProperties;

    private Money(Optional<Long> amount, Optional<Currency> currency, Map<String, Object> additionalProperties) {
        this.amount = amount;
        this.currency = currency;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Long> getAmount() {
        if (this.amount == null) {
            return Optional.empty();
        }
        return this.amount;
    }

    @JsonProperty(value="currency")
    public Optional<Currency> getCurrency() {
        return this.currency;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="amount")
    private Optional<Long> _getAmount() {
        return this.amount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Money && this.equalTo((Money)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Money other) {
        return this.amount.equals(other.amount) && this.currency.equals(other.currency);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currency);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Long> amount = Optional.empty();
        private Optional<Currency> currency = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Money other) {
            this.amount(other.getAmount());
            this.currency(other.getCurrency());
            return this;
        }

        @JsonSetter(value="amount", nulls=Nulls.SKIP)
        public Builder amount(Optional<Long> amount) {
            this.amount = amount;
            return this;
        }

        public Builder amount(Long amount) {
            this.amount = Optional.ofNullable(amount);
            return this;
        }

        public Builder amount(Nullable<Long> amount) {
            this.amount = amount.isNull() ? null : (amount.isEmpty() ? Optional.empty() : Optional.of(amount.get()));
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<Currency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        public Money build() {
            return new Money(this.amount, this.currency, this.additionalProperties);
        }
    }
}

