/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.OauthAuthorizationRevokedEventRevokerType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OauthAuthorizationRevokedEventRevocationObject {
    private final Optional<String> revokedAt;
    private final Optional<OauthAuthorizationRevokedEventRevokerType> revokerType;
    private final Map<String, Object> additionalProperties;

    private OauthAuthorizationRevokedEventRevocationObject(Optional<String> revokedAt, Optional<OauthAuthorizationRevokedEventRevokerType> revokerType, Map<String, Object> additionalProperties) {
        this.revokedAt = revokedAt;
        this.revokerType = revokerType;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getRevokedAt() {
        if (this.revokedAt == null) {
            return Optional.empty();
        }
        return this.revokedAt;
    }

    @JsonProperty(value="revoker_type")
    public Optional<OauthAuthorizationRevokedEventRevokerType> getRevokerType() {
        return this.revokerType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="revoked_at")
    private Optional<String> _getRevokedAt() {
        return this.revokedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OauthAuthorizationRevokedEventRevocationObject && this.equalTo((OauthAuthorizationRevokedEventRevocationObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OauthAuthorizationRevokedEventRevocationObject other) {
        return this.revokedAt.equals(other.revokedAt) && this.revokerType.equals(other.revokerType);
    }

    public int hashCode() {
        return Objects.hash(this.revokedAt, this.revokerType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> revokedAt = Optional.empty();
        private Optional<OauthAuthorizationRevokedEventRevokerType> revokerType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OauthAuthorizationRevokedEventRevocationObject other) {
            this.revokedAt(other.getRevokedAt());
            this.revokerType(other.getRevokerType());
            return this;
        }

        @JsonSetter(value="revoked_at", nulls=Nulls.SKIP)
        public Builder revokedAt(Optional<String> revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        public Builder revokedAt(String revokedAt) {
            this.revokedAt = Optional.ofNullable(revokedAt);
            return this;
        }

        public Builder revokedAt(Nullable<String> revokedAt) {
            this.revokedAt = revokedAt.isNull() ? null : (revokedAt.isEmpty() ? Optional.empty() : Optional.of(revokedAt.get()));
            return this;
        }

        @JsonSetter(value="revoker_type", nulls=Nulls.SKIP)
        public Builder revokerType(Optional<OauthAuthorizationRevokedEventRevokerType> revokerType) {
            this.revokerType = revokerType;
            return this;
        }

        public Builder revokerType(OauthAuthorizationRevokedEventRevokerType revokerType) {
            this.revokerType = Optional.ofNullable(revokerType);
            return this;
        }

        public OauthAuthorizationRevokedEventRevocationObject build() {
            return new OauthAuthorizationRevokedEventRevocationObject(this.revokedAt, this.revokerType, this.additionalProperties);
        }
    }
}

