/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ObtainTokenRequest {
    private final String clientId;
    private final Optional<String> clientSecret;
    private final Optional<String> code;
    private final Optional<String> redirectUri;
    private final String grantType;
    private final Optional<String> refreshToken;
    private final Optional<String> migrationToken;
    private final Optional<List<String>> scopes;
    private final Optional<Boolean> shortLived;
    private final Optional<String> codeVerifier;
    private final Map<String, Object> additionalProperties;

    private ObtainTokenRequest(String clientId, Optional<String> clientSecret, Optional<String> code, Optional<String> redirectUri, String grantType, Optional<String> refreshToken, Optional<String> migrationToken, Optional<List<String>> scopes, Optional<Boolean> shortLived, Optional<String> codeVerifier, Map<String, Object> additionalProperties) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.code = code;
        this.redirectUri = redirectUri;
        this.grantType = grantType;
        this.refreshToken = refreshToken;
        this.migrationToken = migrationToken;
        this.scopes = scopes;
        this.shortLived = shortLived;
        this.codeVerifier = codeVerifier;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    @JsonIgnore
    public Optional<String> getClientSecret() {
        if (this.clientSecret == null) {
            return Optional.empty();
        }
        return this.clientSecret;
    }

    @JsonIgnore
    public Optional<String> getCode() {
        if (this.code == null) {
            return Optional.empty();
        }
        return this.code;
    }

    @JsonIgnore
    public Optional<String> getRedirectUri() {
        if (this.redirectUri == null) {
            return Optional.empty();
        }
        return this.redirectUri;
    }

    @JsonProperty(value="grant_type")
    public String getGrantType() {
        return this.grantType;
    }

    @JsonIgnore
    public Optional<String> getRefreshToken() {
        if (this.refreshToken == null) {
            return Optional.empty();
        }
        return this.refreshToken;
    }

    @JsonIgnore
    public Optional<String> getMigrationToken() {
        if (this.migrationToken == null) {
            return Optional.empty();
        }
        return this.migrationToken;
    }

    @JsonIgnore
    public Optional<List<String>> getScopes() {
        if (this.scopes == null) {
            return Optional.empty();
        }
        return this.scopes;
    }

    @JsonIgnore
    public Optional<Boolean> getShortLived() {
        if (this.shortLived == null) {
            return Optional.empty();
        }
        return this.shortLived;
    }

    @JsonIgnore
    public Optional<String> getCodeVerifier() {
        if (this.codeVerifier == null) {
            return Optional.empty();
        }
        return this.codeVerifier;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="client_secret")
    private Optional<String> _getClientSecret() {
        return this.clientSecret;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="code")
    private Optional<String> _getCode() {
        return this.code;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="redirect_uri")
    private Optional<String> _getRedirectUri() {
        return this.redirectUri;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="refresh_token")
    private Optional<String> _getRefreshToken() {
        return this.refreshToken;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="migration_token")
    private Optional<String> _getMigrationToken() {
        return this.migrationToken;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="scopes")
    private Optional<List<String>> _getScopes() {
        return this.scopes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="short_lived")
    private Optional<Boolean> _getShortLived() {
        return this.shortLived;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="code_verifier")
    private Optional<String> _getCodeVerifier() {
        return this.codeVerifier;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ObtainTokenRequest && this.equalTo((ObtainTokenRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ObtainTokenRequest other) {
        return this.clientId.equals(other.clientId) && this.clientSecret.equals(other.clientSecret) && this.code.equals(other.code) && this.redirectUri.equals(other.redirectUri) && this.grantType.equals(other.grantType) && this.refreshToken.equals(other.refreshToken) && this.migrationToken.equals(other.migrationToken) && this.scopes.equals(other.scopes) && this.shortLived.equals(other.shortLived) && this.codeVerifier.equals(other.codeVerifier);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.code, this.redirectUri, this.grantType, this.refreshToken, this.migrationToken, this.scopes, this.shortLived, this.codeVerifier);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ClientIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ClientIdStage,
    GrantTypeStage,
    _FinalStage {
        private String clientId;
        private String grantType;
        private Optional<String> codeVerifier = Optional.empty();
        private Optional<Boolean> shortLived = Optional.empty();
        private Optional<List<String>> scopes = Optional.empty();
        private Optional<String> migrationToken = Optional.empty();
        private Optional<String> refreshToken = Optional.empty();
        private Optional<String> redirectUri = Optional.empty();
        private Optional<String> code = Optional.empty();
        private Optional<String> clientSecret = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ObtainTokenRequest other) {
            this.clientId(other.getClientId());
            this.clientSecret(other.getClientSecret());
            this.code(other.getCode());
            this.redirectUri(other.getRedirectUri());
            this.grantType(other.getGrantType());
            this.refreshToken(other.getRefreshToken());
            this.migrationToken(other.getMigrationToken());
            this.scopes(other.getScopes());
            this.shortLived(other.getShortLived());
            this.codeVerifier(other.getCodeVerifier());
            return this;
        }

        @Override
        @JsonSetter(value="client_id")
        public GrantTypeStage clientId(@NotNull String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="grant_type")
        public _FinalStage grantType(@NotNull String grantType) {
            this.grantType = Objects.requireNonNull(grantType, "grantType must not be null");
            return this;
        }

        @Override
        public _FinalStage codeVerifier(Nullable<String> codeVerifier) {
            this.codeVerifier = codeVerifier.isNull() ? null : (codeVerifier.isEmpty() ? Optional.empty() : Optional.of(codeVerifier.get()));
            return this;
        }

        @Override
        public _FinalStage codeVerifier(String codeVerifier) {
            this.codeVerifier = Optional.ofNullable(codeVerifier);
            return this;
        }

        @Override
        @JsonSetter(value="code_verifier", nulls=Nulls.SKIP)
        public _FinalStage codeVerifier(Optional<String> codeVerifier) {
            this.codeVerifier = codeVerifier;
            return this;
        }

        @Override
        public _FinalStage shortLived(Nullable<Boolean> shortLived) {
            this.shortLived = shortLived.isNull() ? null : (shortLived.isEmpty() ? Optional.empty() : Optional.of(shortLived.get()));
            return this;
        }

        @Override
        public _FinalStage shortLived(Boolean shortLived) {
            this.shortLived = Optional.ofNullable(shortLived);
            return this;
        }

        @Override
        @JsonSetter(value="short_lived", nulls=Nulls.SKIP)
        public _FinalStage shortLived(Optional<Boolean> shortLived) {
            this.shortLived = shortLived;
            return this;
        }

        @Override
        public _FinalStage scopes(Nullable<List<String>> scopes) {
            this.scopes = scopes.isNull() ? null : (scopes.isEmpty() ? Optional.empty() : Optional.of(scopes.get()));
            return this;
        }

        @Override
        public _FinalStage scopes(List<String> scopes) {
            this.scopes = Optional.ofNullable(scopes);
            return this;
        }

        @Override
        @JsonSetter(value="scopes", nulls=Nulls.SKIP)
        public _FinalStage scopes(Optional<List<String>> scopes) {
            this.scopes = scopes;
            return this;
        }

        @Override
        public _FinalStage migrationToken(Nullable<String> migrationToken) {
            this.migrationToken = migrationToken.isNull() ? null : (migrationToken.isEmpty() ? Optional.empty() : Optional.of(migrationToken.get()));
            return this;
        }

        @Override
        public _FinalStage migrationToken(String migrationToken) {
            this.migrationToken = Optional.ofNullable(migrationToken);
            return this;
        }

        @Override
        @JsonSetter(value="migration_token", nulls=Nulls.SKIP)
        public _FinalStage migrationToken(Optional<String> migrationToken) {
            this.migrationToken = migrationToken;
            return this;
        }

        @Override
        public _FinalStage refreshToken(Nullable<String> refreshToken) {
            this.refreshToken = refreshToken.isNull() ? null : (refreshToken.isEmpty() ? Optional.empty() : Optional.of(refreshToken.get()));
            return this;
        }

        @Override
        public _FinalStage refreshToken(String refreshToken) {
            this.refreshToken = Optional.ofNullable(refreshToken);
            return this;
        }

        @Override
        @JsonSetter(value="refresh_token", nulls=Nulls.SKIP)
        public _FinalStage refreshToken(Optional<String> refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @Override
        public _FinalStage redirectUri(Nullable<String> redirectUri) {
            this.redirectUri = redirectUri.isNull() ? null : (redirectUri.isEmpty() ? Optional.empty() : Optional.of(redirectUri.get()));
            return this;
        }

        @Override
        public _FinalStage redirectUri(String redirectUri) {
            this.redirectUri = Optional.ofNullable(redirectUri);
            return this;
        }

        @Override
        @JsonSetter(value="redirect_uri", nulls=Nulls.SKIP)
        public _FinalStage redirectUri(Optional<String> redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        @Override
        public _FinalStage code(Nullable<String> code) {
            this.code = code.isNull() ? null : (code.isEmpty() ? Optional.empty() : Optional.of(code.get()));
            return this;
        }

        @Override
        public _FinalStage code(String code) {
            this.code = Optional.ofNullable(code);
            return this;
        }

        @Override
        @JsonSetter(value="code", nulls=Nulls.SKIP)
        public _FinalStage code(Optional<String> code) {
            this.code = code;
            return this;
        }

        @Override
        public _FinalStage clientSecret(Nullable<String> clientSecret) {
            this.clientSecret = clientSecret.isNull() ? null : (clientSecret.isEmpty() ? Optional.empty() : Optional.of(clientSecret.get()));
            return this;
        }

        @Override
        public _FinalStage clientSecret(String clientSecret) {
            this.clientSecret = Optional.ofNullable(clientSecret);
            return this;
        }

        @Override
        @JsonSetter(value="client_secret", nulls=Nulls.SKIP)
        public _FinalStage clientSecret(Optional<String> clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @Override
        public ObtainTokenRequest build() {
            return new ObtainTokenRequest(this.clientId, this.clientSecret, this.code, this.redirectUri, this.grantType, this.refreshToken, this.migrationToken, this.scopes, this.shortLived, this.codeVerifier, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ObtainTokenRequest build();

        public _FinalStage clientSecret(Optional<String> var1);

        public _FinalStage clientSecret(String var1);

        public _FinalStage clientSecret(Nullable<String> var1);

        public _FinalStage code(Optional<String> var1);

        public _FinalStage code(String var1);

        public _FinalStage code(Nullable<String> var1);

        public _FinalStage redirectUri(Optional<String> var1);

        public _FinalStage redirectUri(String var1);

        public _FinalStage redirectUri(Nullable<String> var1);

        public _FinalStage refreshToken(Optional<String> var1);

        public _FinalStage refreshToken(String var1);

        public _FinalStage refreshToken(Nullable<String> var1);

        public _FinalStage migrationToken(Optional<String> var1);

        public _FinalStage migrationToken(String var1);

        public _FinalStage migrationToken(Nullable<String> var1);

        public _FinalStage scopes(Optional<List<String>> var1);

        public _FinalStage scopes(List<String> var1);

        public _FinalStage scopes(Nullable<List<String>> var1);

        public _FinalStage shortLived(Optional<Boolean> var1);

        public _FinalStage shortLived(Boolean var1);

        public _FinalStage shortLived(Nullable<Boolean> var1);

        public _FinalStage codeVerifier(Optional<String> var1);

        public _FinalStage codeVerifier(String var1);

        public _FinalStage codeVerifier(Nullable<String> var1);
    }

    public static interface GrantTypeStage {
        public _FinalStage grantType(@NotNull String var1);
    }

    public static interface ClientIdStage {
        public GrantTypeStage clientId(@NotNull String var1);

        public Builder from(ObtainTokenRequest var1);
    }
}

