/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ObtainTokenResponse {
    private final Optional<String> accessToken;
    private final Optional<String> tokenType;
    private final Optional<String> expiresAt;
    private final Optional<String> merchantId;
    private final Optional<String> subscriptionId;
    private final Optional<String> planId;
    private final Optional<String> idToken;
    private final Optional<String> refreshToken;
    private final Optional<Boolean> shortLived;
    private final Optional<List<Error>> errors;
    private final Optional<String> refreshTokenExpiresAt;
    private final Map<String, Object> additionalProperties;

    private ObtainTokenResponse(Optional<String> accessToken, Optional<String> tokenType, Optional<String> expiresAt, Optional<String> merchantId, Optional<String> subscriptionId, Optional<String> planId, Optional<String> idToken, Optional<String> refreshToken, Optional<Boolean> shortLived, Optional<List<Error>> errors, Optional<String> refreshTokenExpiresAt, Map<String, Object> additionalProperties) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresAt = expiresAt;
        this.merchantId = merchantId;
        this.subscriptionId = subscriptionId;
        this.planId = planId;
        this.idToken = idToken;
        this.refreshToken = refreshToken;
        this.shortLived = shortLived;
        this.errors = errors;
        this.refreshTokenExpiresAt = refreshTokenExpiresAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="access_token")
    public Optional<String> getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="token_type")
    public Optional<String> getTokenType() {
        return this.tokenType;
    }

    @JsonProperty(value="expires_at")
    public Optional<String> getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="merchant_id")
    public Optional<String> getMerchantId() {
        return this.merchantId;
    }

    @JsonProperty(value="subscription_id")
    public Optional<String> getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonProperty(value="plan_id")
    public Optional<String> getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="id_token")
    public Optional<String> getIdToken() {
        return this.idToken;
    }

    @JsonProperty(value="refresh_token")
    public Optional<String> getRefreshToken() {
        return this.refreshToken;
    }

    @JsonProperty(value="short_lived")
    public Optional<Boolean> getShortLived() {
        return this.shortLived;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="refresh_token_expires_at")
    public Optional<String> getRefreshTokenExpiresAt() {
        return this.refreshTokenExpiresAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ObtainTokenResponse && this.equalTo((ObtainTokenResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ObtainTokenResponse other) {
        return this.accessToken.equals(other.accessToken) && this.tokenType.equals(other.tokenType) && this.expiresAt.equals(other.expiresAt) && this.merchantId.equals(other.merchantId) && this.subscriptionId.equals(other.subscriptionId) && this.planId.equals(other.planId) && this.idToken.equals(other.idToken) && this.refreshToken.equals(other.refreshToken) && this.shortLived.equals(other.shortLived) && this.errors.equals(other.errors) && this.refreshTokenExpiresAt.equals(other.refreshTokenExpiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.expiresAt, this.merchantId, this.subscriptionId, this.planId, this.idToken, this.refreshToken, this.shortLived, this.errors, this.refreshTokenExpiresAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> accessToken = Optional.empty();
        private Optional<String> tokenType = Optional.empty();
        private Optional<String> expiresAt = Optional.empty();
        private Optional<String> merchantId = Optional.empty();
        private Optional<String> subscriptionId = Optional.empty();
        private Optional<String> planId = Optional.empty();
        private Optional<String> idToken = Optional.empty();
        private Optional<String> refreshToken = Optional.empty();
        private Optional<Boolean> shortLived = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<String> refreshTokenExpiresAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ObtainTokenResponse other) {
            this.accessToken(other.getAccessToken());
            this.tokenType(other.getTokenType());
            this.expiresAt(other.getExpiresAt());
            this.merchantId(other.getMerchantId());
            this.subscriptionId(other.getSubscriptionId());
            this.planId(other.getPlanId());
            this.idToken(other.getIdToken());
            this.refreshToken(other.getRefreshToken());
            this.shortLived(other.getShortLived());
            this.errors(other.getErrors());
            this.refreshTokenExpiresAt(other.getRefreshTokenExpiresAt());
            return this;
        }

        @JsonSetter(value="access_token", nulls=Nulls.SKIP)
        public Builder accessToken(Optional<String> accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = Optional.ofNullable(accessToken);
            return this;
        }

        @JsonSetter(value="token_type", nulls=Nulls.SKIP)
        public Builder tokenType(Optional<String> tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder tokenType(String tokenType) {
            this.tokenType = Optional.ofNullable(tokenType);
            return this;
        }

        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public Builder expiresAt(Optional<String> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder expiresAt(String expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @JsonSetter(value="merchant_id", nulls=Nulls.SKIP)
        public Builder merchantId(Optional<String> merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = Optional.ofNullable(merchantId);
            return this;
        }

        @JsonSetter(value="subscription_id", nulls=Nulls.SKIP)
        public Builder subscriptionId(Optional<String> subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = Optional.ofNullable(subscriptionId);
            return this;
        }

        @JsonSetter(value="plan_id", nulls=Nulls.SKIP)
        public Builder planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        public Builder planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @JsonSetter(value="id_token", nulls=Nulls.SKIP)
        public Builder idToken(Optional<String> idToken) {
            this.idToken = idToken;
            return this;
        }

        public Builder idToken(String idToken) {
            this.idToken = Optional.ofNullable(idToken);
            return this;
        }

        @JsonSetter(value="refresh_token", nulls=Nulls.SKIP)
        public Builder refreshToken(Optional<String> refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = Optional.ofNullable(refreshToken);
            return this;
        }

        @JsonSetter(value="short_lived", nulls=Nulls.SKIP)
        public Builder shortLived(Optional<Boolean> shortLived) {
            this.shortLived = shortLived;
            return this;
        }

        public Builder shortLived(Boolean shortLived) {
            this.shortLived = Optional.ofNullable(shortLived);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="refresh_token_expires_at", nulls=Nulls.SKIP)
        public Builder refreshTokenExpiresAt(Optional<String> refreshTokenExpiresAt) {
            this.refreshTokenExpiresAt = refreshTokenExpiresAt;
            return this;
        }

        public Builder refreshTokenExpiresAt(String refreshTokenExpiresAt) {
            this.refreshTokenExpiresAt = Optional.ofNullable(refreshTokenExpiresAt);
            return this;
        }

        public ObtainTokenResponse build() {
            return new ObtainTokenResponse(this.accessToken, this.tokenType, this.expiresAt, this.merchantId, this.subscriptionId, this.planId, this.idToken, this.refreshToken, this.shortLived, this.errors, this.refreshTokenExpiresAt, this.additionalProperties);
        }
    }
}

