/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OfflinePaymentDetails {
    private final Optional<String> clientCreatedAt;
    private final Map<String, Object> additionalProperties;

    private OfflinePaymentDetails(Optional<String> clientCreatedAt, Map<String, Object> additionalProperties) {
        this.clientCreatedAt = clientCreatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="client_created_at")
    public Optional<String> getClientCreatedAt() {
        return this.clientCreatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OfflinePaymentDetails && this.equalTo((OfflinePaymentDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OfflinePaymentDetails other) {
        return this.clientCreatedAt.equals(other.clientCreatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.clientCreatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> clientCreatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OfflinePaymentDetails other) {
            this.clientCreatedAt(other.getClientCreatedAt());
            return this;
        }

        @JsonSetter(value="client_created_at", nulls=Nulls.SKIP)
        public Builder clientCreatedAt(Optional<String> clientCreatedAt) {
            this.clientCreatedAt = clientCreatedAt;
            return this;
        }

        public Builder clientCreatedAt(String clientCreatedAt) {
            this.clientCreatedAt = Optional.ofNullable(clientCreatedAt);
            return this;
        }

        public OfflinePaymentDetails build() {
            return new OfflinePaymentDetails(this.clientCreatedAt, this.additionalProperties);
        }
    }
}

